#include "./aaccodebook.h"

/*!
 * \file aaccodebook.cpp
 * \remarks The AAC parser is still WIP. It does not work yet and its API/ABI may change even in patch releases.
 */

namespace TagParser {

/// \cond

// clang-format off
const AacHcb *const aacHcbTable[] = {
    nullptr, aacHcb1Step1, aacHcb2Step1, nullptr, aacHcb4Step1, nullptr, aacHcb6Step1, nullptr, aacHcb8Step1, nullptr, aacHcb10Step1, aacHcb11Step1
};

const AacHcb2Pair *const aacHcb2PairTable[] = {
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, aacHcb6Step2, nullptr, aacHcb8Step2, nullptr, aacHcb10Step2, aacHcb11Step2
};

const AacHcb2Quad *const aacHcb2QuadTable[] = {
    nullptr, aacHcb1Step2, aacHcb2Step2, nullptr, aacHcb4Step2, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr
};

const AacHcbBinPair *const aacHcbBinTable[] = {
    nullptr, nullptr, nullptr, nullptr, nullptr, aacHcb5, nullptr, aacHcb7, nullptr, aacHcb9, nullptr, nullptr
};

const std::uint8_t aacHcbN[] = { 0, 5, 5, 0, 5, 0, 5, 0, 5, 0, 6, 5 };

//const std::uint8_t unsignedCb[] = { 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0,
//  /* codebook 16 to 31 */ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
//};

const int aacHcb2QuadTableSize[] = { 0, 114, 86, 0, 185, 0, 0, 0, 0, 0, 0, 0 };
const int aacHcb2PairTableSize[] = { 0, 0, 0, 0, 0, 0, 126, 0, 83, 0, 210, 373 };
const int aacHcbBinTableSize[] = { 0, 0, 0, 161, 0, 161, 0, 127, 0, 337, 0, 0 };

const AacHcb aacHcb1Step1[] = {
    { /* 00000 */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /* 10000 */ 1, 0 },
    { /* 10001 */ 2, 0 },
    { /* 10010 */ 3, 0 },
    { /* 10011 */ 4, 0 },
    { /* 10100 */ 5, 0 },
    { /* 10101 */ 6, 0 },
    { /* 10110 */ 7, 0 },
    { /* 10111 */ 8, 0 },

    // 7 bit codewords
    { /* 11000 */ 9,  2 },
    { /* 11001 */ 13, 2 },
    { /* 11010 */ 17, 2 },
    { /* 11011 */ 21, 2 },
    { /* 11100 */ 25, 2 },
    { /* 11101 */ 29, 2 },

    // 9 bit codewords
    { /* 11110 */ 33, 4 },

    // 9/10/11 bit codewords
    { /* 11111 */ 49, 6 }
};

const AacHcb2Quad aacHcb1Step2[] = {
    // 1 bit codeword
    { 1,  0,  0,  0,  0 },

    // 5 bit codewords
    { 5,  1,  0,  0,  0 },
    { 5, -1,  0,  0,  0 },
    { 5,  0,  0,  0, -1 },
    { 5,  0,  1,  0,  0 },
    { 5,  0,  0,  0,  1 },
    { 5,  0,  0, -1,  0 },
    { 5,  0,  0,  1,  0 },
    { 5,  0, -1,  0,  0 },

    // 7 bit codewords
    // first 5 bits: 11000
    { 7,  1, -1,  0,  0 },
    { 7, -1,  1,  0,  0 },
    { 7,  0,  0, -1,  1 },
    { 7,  0,  1, -1,  0 },
    // first 5 bits: 11001
    { 7,  0, -1,  1,  0 },
    { 7,  0,  0,  1, -1 },
    { 7,  1,  1,  0,  0 },
    { 7,  0,  0, -1, -1 },
    // first 5 bits: 11010
    { 7, -1, -1,  0,  0 },
    { 7,  0, -1, -1,  0 },
    { 7,  1,  0, -1,  0 },
    { 7,  0,  1,  0, -1 },
    // first 5 bits: 11011
    { 7, -1,  0,  1,  0 },
    { 7,  0,  0,  1,  1 },
    { 7,  1,  0,  1,  0 },
    { 7,  0, -1,  0,  1 },
    // first 5 bits: 11100
    { 7,  0,  1,  1,  0 },
    { 7,  0,  1,  0,  1 },
    { 7, -1,  0, -1,  0 },
    { 7,  1,  0,  0,  1 },
    // first 5 bits: 11101
    { 7, -1,  0,  0, -1 },
    { 7,  1,  0,  0, -1 },
    { 7, -1,  0,  0,  1 },
    { 7,  0, -1,  0, -1 },

    // 9 bit codeword
    // first 5 bits: 11110
    { 9,  1,  1, -1,  0 },
    { 9, -1,  1, -1,  0 },
    { 9,  1, -1,  1,  0 },
    { 9,  0,  1,  1, -1 },
    { 9,  0,  1, -1,  1 },
    { 9,  0, -1,  1,  1 },
    { 9,  0, -1,  1, -1 },
    { 9,  1, -1, -1,  0 },
    { 9,  1,  0, -1,  1 },
    { 9,  0,  1, -1, -1 },
    { 9, -1,  1,  1,  0 },
    { 9, -1,  0,  1, -1 },
    { 9, -1, -1,  1,  0 },
    { 9,  0, -1, -1,  1 },
    { 9,  1, -1,  0,  1 },
    { 9,  1, -1,  0, -1 },

    // 9/10/11 bit codewords
    // first 5 bits: 11111
    // 9 bit: reading 11 bits -> 2 too much so 4 entries for each codeword
    { 9, -1,  1,  0, -1 }, { 9, -1,  1,  0, -1 }, { 9, -1,  1,  0, -1 }, { 9, -1,  1,  0, -1 },
    { 9, -1, -1, -1,  0 }, { 9, -1, -1, -1,  0 }, { 9, -1, -1, -1,  0 }, { 9, -1, -1, -1,  0 },
    { 9,  0, -1, -1, -1 }, { 9,  0, -1, -1, -1 }, { 9,  0, -1, -1, -1 }, { 9,  0, -1, -1, -1 },
    { 9,  0,  1,  1,  1 }, { 9,  0,  1,  1,  1 }, { 9,  0,  1,  1,  1 }, { 9,  0,  1,  1,  1 },
    { 9,  1,  0,  1, -1 }, { 9,  1,  0,  1, -1 }, { 9,  1,  0,  1, -1 }, { 9,  1,  0,  1, -1 },
    { 9,  1,  1,  0,  1 }, { 9,  1,  1,  0,  1 }, { 9,  1,  1,  0,  1 }, { 9,  1,  1,  0,  1 },
    { 9, -1,  1,  0,  1 }, { 9, -1,  1,  0,  1 }, { 9, -1,  1,  0,  1 }, { 9, -1,  1,  0,  1 },
    { 9,  1,  1,  1,  0 }, { 9,  1,  1,  1,  0 }, { 9,  1,  1,  1,  0 }, { 9,  1,  1,  1,  0 },
    // 10 bit: reading 11 bits -> 1 too much so 2 entries for each codeword
    { 10, -1, -1,  0,  1 }, { 10, -1, -1,  0,  1 },
    { 10, -1,  0, -1, -1 }, { 10, -1,  0, -1, -1 },
    { 10,  1,  1,  0, -1 }, { 10,  1,  1,  0, -1 },
    { 10,  1,  0, -1, -1 }, { 10,  1,  0, -1, -1 },
    { 10, -1,  0, -1,  1 }, { 10, -1,  0, -1,  1 },
    { 10, -1, -1,  0, -1 }, { 10, -1, -1,  0, -1 },
    { 10, -1,  0,  1,  1 }, { 10, -1,  0,  1,  1 },
    { 10,  1,  0,  1,  1 }, { 10,  1,  0,  1,  1 },
    // 11 bit
    { 11,  1, -1,  1, -1 },
    { 11, -1,  1, -1,  1 },
    { 11, -1,  1,  1, -1 },
    { 11,  1, -1, -1,  1 },
    { 11,  1,  1,  1,  1 },
    { 11, -1, -1,  1,  1 },
    { 11,  1,  1, -1, -1 },
    { 11, -1, -1,  1, -1 },
    { 11, -1, -1, -1, -1 },
    { 11,  1,  1, -1,  1 },
    { 11,  1, -1,  1,  1 },
    { 11, -1,  1,  1,  1 },
    { 11, -1,  1, -1, -1 },
    { 11, -1, -1, -1,  1 },
    { 11,  1, -1, -1, -1 },
    { 11,  1,  1,  1, -1 }
};

const AacHcb aacHcb2Step1[] = {
    { /* 00000 */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /* 00100 */ 1, 0 },
    { /*       */ 1, 0 },
    { /* 00110 */ 2, 0 },
    { /* 00111 */ 3, 0 },
    { /* 01000 */ 4, 0 },
    { /* 01001 */ 5, 0 },
    { /* 01010 */ 6, 0 },
    { /* 01011 */ 7, 0 },
    { /* 01100 */ 8, 0 },

    // 6 bit codewords
    { /* 01101 */ 9,  1 },
    { /* 01110 */ 11, 1 },
    { /* 01111 */ 13, 1 },
    { /* 10000 */ 15, 1 },
    { /* 10001 */ 17, 1 },
    { /* 10010 */ 19, 1 },
    { /* 10011 */ 21, 1 },
    { /* 10100 */ 23, 1 },
    { /* 10101 */ 25, 1 },
    { /* 10110 */ 27, 1 },
    { /* 10111 */ 29, 1 },
    { /* 11000 */ 31, 1 },

    // 7 bit codewords
    { /* 11001 */ 33, 2 },
    { /* 11010 */ 37, 2 },
    { /* 11011 */ 41, 2 },

    // 7/8 bit codewords
    { /* 11100 */ 45, 3 },

    // 8 bit codewords
    { /* 11101 */ 53, 3 },
    { /* 11110 */ 61, 3 },

    // 8/9 bit codewords
    { /* 11111 */ 69, 4 }
};

const AacHcb2Quad aacHcb2Step2[] = {
    // 3 bit codeword
    { 3,  0,  0,  0,  0 },

    // 4 bit codeword
    { 4,  1,  0,  0,  0 },

    // 5 bit codewords
    { 5, -1,  0,  0,  0 },
    { 5,  0,  0,  0,  1 },
    { 5,  0,  0, -1,  0 },
    { 5,  0,  0,  0, -1 },
    { 5,  0, -1,  0,  0 },
    { 5,  0,  0,  1,  0 },
    { 5,  0,  1,  0,  0 },

    // 6 bit codewords
    { 6,  0, -1,  1,  0 },
    { 6, -1,  1,  0,  0 },
    { 6,  0,  1, -1,  0 },
    { 6,  0,  0,  1, -1 },
    { 6,  0,  1,  0, -1 },
    { 6,  0,  0, -1,  1 },
    { 6, -1,  0,  0, -1 },
    { 6,  1, -1,  0,  0 },
    { 6,  1,  0, -1,  0 },
    { 6, -1, -1,  0,  0 },
    { 6,  0,  0, -1, -1 },
    { 6,  1,  0,  1,  0 },
    { 6,  1,  0,  0,  1 },
    { 6,  0, -1,  0,  1 },
    { 6, -1,  0,  1,  0 },
    { 6,  0,  1,  0,  1 },
    { 6,  0, -1, -1,  0 },
    { 6, -1,  0,  0,  1 },
    { 6,  0, -1,  0, -1 },
    { 6, -1,  0, -1,  0 },
    { 6,  1,  1,  0,  0 },
    { 6,  0,  1,  1,  0 },
    { 6,  0,  0,  1,  1 },
    { 6,  1,  0,  0, -1 },

    // 7 bit codewords
    { 7,  0,  1, -1,  1 },
    { 7,  1,  0, -1,  1 },
    { 7, -1,  1, -1,  0 },
    { 7,  0, -1,  1, -1 },
    { 7,  1, -1,  1,  0 },
    { 7,  1,  1,  0, -1 },
    { 7,  1,  0,  1,  1 },
    { 7, -1,  1,  1,  0 },
    { 7,  0, -1, -1,  1 },
    { 7,  1,  1,  1,  0 },
    { 7, -1,  0,  1, -1 },
    { 7, -1, -1, -1,  0 },

    // 7/8 bit codewords
    { 7, -1,  0, -1,  1 }, { 7, -1,  0, -1,  1 },
    { 7,  1, -1, -1,  0 }, { 7,  1, -1, -1,  0 },
    { 7,  1,  1, -1,  0 }, { 7,  1,  1, -1,  0 },
    { 8,  1, -1,  0,  1 },
    { 8, -1,  1,  0, -1 },

    // 8 bit codewords
    { 8, -1, -1,  1,  0 },
    { 8, -1,  0,  1,  1 },
    { 8, -1, -1,  0,  1 },
    { 8, -1, -1,  0, -1 },
    { 8,  0, -1, -1, -1 },
    { 8,  1,  0,  1, -1 },
    { 8,  1,  0, -1, -1 },
    { 8,  0,  1, -1, -1 },
    { 8,  0,  1,  1,  1 },
    { 8, -1,  1,  0,  1 },
    { 8, -1,  0, -1, -1 },
    { 8,  0,  1,  1, -1 },
    { 8,  1, -1,  0, -1 },
    { 8,  0, -1,  1,  1 },
    { 8,  1,  1,  0,  1 },
    { 8,  1, -1,  1, -1 },

    // 8/9 bit codewords
    { 8, -1,  1, -1,  1 }, { 8, -1,  1, -1,  1 },
    { 9,  1, -1, -1,  1 },
    { 9, -1, -1, -1, -1 },
    { 9, -1,  1,  1, -1 },
    { 9, -1,  1,  1,  1 },
    { 9,  1,  1,  1,  1 },
    { 9, -1, -1,  1, -1 },
    { 9,  1, -1,  1,  1 },
    { 9, -1,  1, -1, -1 },
    { 9, -1, -1,  1,  1 },
    { 9,  1,  1, -1, -1 },
    { 9,  1, -1, -1, -1 },
    { 9, -1, -1, -1,  1 },
    { 9,  1,  1, -1,  1 },
    { 9,  1,  1,  1, -1 }
};

const AacHcbBinQuad aacHcb3[] = {
    { /*  0 */ 0, {  1,  2, 0, 0 } },
    { /*  1 */ 1, {  0,  0, 0, 0 } }, // 0
    { /*  2 */ 0, {  1,  2, 0, 0 } },
    { /*  3 */ 0, {  2,  3, 0, 0 } },
    { /*  4 */ 0, {  3,  4, 0, 0 } },
    { /*  5 */ 0, {  4,  5, 0, 0 } },
    { /*  6 */ 0, {  5,  6, 0, 0 } },
    { /*  7 */ 0, {  6,  7, 0, 0 } },
    { /*  8 */ 0, {  7,  8, 0, 0 } },
    { /*  9 */ 1, {  1,  0, 0, 0 } }, // 1000
    { /* 10 */ 1, {  0,  0, 0, 1 } }, // 1001
    { /* 11 */ 1, {  0,  1, 0, 0 } }, // 1010
    { /* 12 */ 1, {  0,  0, 1, 0 } }, // 1011
    { /* 13 */ 0, {  4,  5, 0, 0 } },
    { /* 14 */ 0, {  5,  6, 0, 0 } },
    { /* 15 */ 0, {  6,  7, 0, 0 } },
    { /* 16 */ 0, {  7,  8, 0, 0 } },
    { /* 17 */ 1, {  1,  1, 0, 0 } },
    { /* 18 */ 1, {  0,  0, 1, 1 } },
    { /* 19 */ 0, {  6,  7, 0, 0 } },
    { /* 20 */ 0, {  7,  8, 0, 0 } },
    { /* 21 */ 0, {  8,  9, 0, 0 } },
    { /* 22 */ 0, {  9, 10, 0, 0 } },
    { /* 23 */ 0, { 10, 11, 0, 0 } },
    { /* 24 */ 0, { 11, 12, 0, 0 } },
    { /* 25 */ 1, {  0,  1, 1, 0 } }, // 110100
    { /* 26 */ 1, {  0,  1, 0, 1 } }, // 110101
    { /* 27 */ 1, {  1,  0, 1, 0 } }, // 110110
    { /* 28 */ 1, {  0,  1, 1, 1 } }, // 110111
    { /* 29 */ 1, {  1,  0, 0, 1 } }, // 111000
    { /* 30 */ 1, {  1,  1, 1, 0 } }, // 111001
    { /* 31 */ 0, {  6,  7, 0, 0 } },
    { /* 32 */ 0, {  7,  8, 0, 0 } },
    { /* 33 */ 0, {  8,  9, 0, 0 } },
    { /* 34 */ 0, {  9, 10, 0, 0 } },
    { /* 35 */ 0, { 10, 11, 0, 0 } },
    { /* 36 */ 0, { 11, 12, 0, 0 } },
    { /* 37 */ 1, {  1,  1, 1, 1 } }, // 1110100
    { /* 38 */ 1, {  1,  0, 1, 1 } }, // 1110101
    { /* 39 */ 1, {  1,  1, 0, 1 } }, // 1110110
    { /* 40 */ 0, {  9, 10, 0, 0 } },
    { /* 41 */ 0, { 10, 11, 0, 0 } },
    { /* 42 */ 0, { 11, 12, 0, 0 } },
    { /* 43 */ 0, { 12, 13, 0, 0 } },
    { /* 44 */ 0, { 13, 14, 0, 0 } },
    { /* 45 */ 0, { 14, 15, 0, 0 } },
    { /* 46 */ 0, { 15, 16, 0, 0 } },
    { /* 47 */ 0, { 16, 17, 0, 0 } },
    { /* 48 */ 0, { 17, 18, 0, 0 } },
    { /* 49 */ 1, {  2,  0, 0, 0 } }, // 11101110
    { /* 50 */ 1, {  0,  0, 0, 2 } }, // 11101111
    { /* 51 */ 1, {  0,  0, 1, 2 } }, // 11110000
    { /* 52 */ 1, {  2,  1, 0, 0 } }, // 11110001
    { /* 53 */ 1, {  1,  2, 1, 0 } }, // 11110010
    { /* 54 */ 0, { 13, 14, 0, 0 } },
    { /* 55 */ 0, { 14, 15, 0, 0 } },
    { /* 56 */ 0, { 15, 16, 0, 0 } },
    { /* 57 */ 0, { 16, 17, 0, 0 } },
    { /* 58 */ 0, { 17, 18, 0, 0 } },
    { /* 59 */ 0, { 18, 19, 0, 0 } },
    { /* 60 */ 0, { 19, 20, 0, 0 } },
    { /* 61 */ 0, { 20, 21, 0, 0 } },
    { /* 62 */ 0, { 21, 22, 0, 0 } },
    { /* 63 */ 0, { 22, 23, 0, 0 } },
    { /* 64 */ 0, { 23, 24, 0, 0 } },
    { /* 65 */ 0, { 24, 25, 0, 0 } },
    { /* 66 */ 0, { 25, 26, 0, 0 } },
    { /* 67 */ 1, {  0,  0, 2, 1 } },
    { /* 68 */ 1, {  0,  1, 2, 1 } },
    { /* 69 */ 1, {  1,  2, 0, 0 } },
    { /* 70 */ 1, {  0,  1, 1, 2 } },
    { /* 71 */ 1, {  2,  1, 1, 0 } },
    { /* 72 */ 1, {  0,  0, 2, 0 } },
    { /* 73 */ 1, {  0,  2, 1, 0 } },
    { /* 74 */ 1, {  0,  1, 2, 0 } },
    { /* 75 */ 1, {  0,  2, 0, 0 } },
    { /* 76 */ 1, {  0,  1, 0, 2 } },
    { /* 77 */ 1, {  2,  0, 1, 0 } },
    { /* 78 */ 1, {  1,  2, 1, 1 } },
    { /* 79 */ 1, {  0,  2, 1, 1 } },
    { /* 80 */ 1, {  1,  1, 2, 0 } },
    { /* 81 */ 1, {  1,  1, 2, 1 } },
    { /* 82 */ 0, { 11, 12, 0, 0 } },
    { /* 83 */ 0, { 12, 13, 0, 0 } },
    { /* 84 */ 0, { 13, 14, 0, 0 } },
    { /* 85 */ 0, { 14, 15, 0, 0 } },
    { /* 86 */ 0, { 15, 16, 0, 0 } },
    { /* 87 */ 0, { 16, 17, 0, 0 } },
    { /* 88 */ 0, { 17, 18, 0, 0 } },
    { /* 89 */ 0, { 18, 19, 0, 0 } },
    { /* 90 */ 0, { 19, 20, 0, 0 } },
    { /* 91 */ 0, { 20, 21, 0, 0 } },
    { /* 92 */ 0, { 21, 22, 0, 0 } },
    { /* 93 */ 1, {  1,  2,  0,  1 } }, // 1111101010
    { /* 94 */ 1, {  1,  0,  2,  0 } }, // 1111101011
    { /* 95 */ 1, {  1,  0,  2,  1 } }, // 1111101100
    { /* 96 */ 1, {  0,  2,  0,  1 } }, // 1111101101
    { /* 97 */ 1, {  2,  1,  1,  1 } }, // 1111101110
    { /* 98 */ 1, {  1,  1,  1,  2 } }, // 1111101111
    { /* 99 */ 1, {  2,  1,  0,  1 } }, // 1111110000
    { /* 00 */ 1, {  1,  0,  1,  2 } }, // 1111110001
    { /* 01 */ 1, {  0,  0,  2,  2 } }, // 1111110010
    { /* 02 */ 1, {  0,  1,  2,  2 } }, // 1111110011
    { /* 03 */ 1, {  2,  2,  1,  0 } }, // 1111110100
    { /* 04 */ 1, {  1,  2,  2,  0 } }, // 1111110101
    { /* 05 */ 1, {  1,  0,  0,  2 } }, // 1111110110
    { /* 06 */ 1, {  2,  0,  0,  1 } }, // 1111110111
    { /* 07 */ 1, {  0,  2,  2,  1 } }, // 1111111000
    { /* 08 */ 0, {  7,  8, 0, 0 } },
    { /* 09 */ 0, {  8,  9, 0, 0 } },
    { /* 10 */ 0, {  9, 10, 0, 0 } },
    { /* 11 */ 0, { 10, 11, 0, 0 } },
    { /* 12 */ 0, { 11, 12, 0, 0 } },
    { /* 13 */ 0, { 12, 13, 0, 0 } },
    { /* 14 */ 0, { 13, 14, 0, 0 } },
    { /* 15 */ 1, {  2,  2,  0,  0 } }, // 11111110010
    { /* 16 */ 1, {  1,  2,  2,  1 } }, // 11111110011
    { /* 17 */ 1, {  1,  1,  0,  2 } }, // 11111110100
    { /* 18 */ 1, {  2,  0,  1,  1 } }, // 11111110101
    { /* 19 */ 1, {  1,  1,  2,  2 } }, // 11111110110
    { /* 20 */ 1, {  2,  2,  1,  1 } }, // 11111110111
    { /* 21 */ 1, {  0,  2,  2,  0 } }, // 11111111000
    { /* 22 */ 1, {  0,  2,  1,  2 } }, // 11111111001
    { /* 23 */ 0, {  6,  7, 0, 0 } },
    { /* 24 */ 0, {  7,  8, 0, 0 } },
    { /* 25 */ 0, {  8,  9, 0, 0 } },
    { /* 26 */ 0, {  9, 10, 0, 0 } },
    { /* 27 */ 0, { 10, 11, 0, 0 } },
    { /* 28 */ 0, { 11, 12, 0, 0 } },
    { /* 29 */ 1, {  1,  0,  2,  2 } }, // 111111110100
    { /* 30 */ 1, {  2,  2,  0,  1 } }, // 111111110101
    { /* 31 */ 1, {  2,  1,  2,  0 } }, // 111111110110
    { /* 32 */ 1, {  2,  2,  2,  0 } }, // 111111110111
    { /* 33 */ 1, {  0,  2,  2,  2 } }, // 111111111000
    { /* 34 */ 1, {  2,  2,  2,  1 } }, // 111111111001
    { /* 35 */ 1, {  2,  1,  2,  1 } }, // 111111111010
    { /* 36 */ 1, {  1,  2,  1,  2 } }, // 111111111011
    { /* 37 */ 1, {  1,  2,  2,  2 } }, // 111111111100
    { /* 38 */ 0, {  3,  4, 0, 0 } },
    { /* 39 */ 0, {  4,  5, 0, 0 } },
    { /* 40 */ 0, {  5,  6, 0, 0 } },
    { /* 41 */ 1, {  0,  2,  0,  2 } }, // 1111111111010
    { /* 42 */ 1, {  2,  0,  2,  0 } }, // 1111111111011
    { /* 43 */ 1, {  1,  2,  0,  2 } }, // 1111111111100
    { /* 44 */ 0, {  3, 4, 0, 0 } },
    { /* 45 */ 0, {  4, 5, 0, 0 } },
    { /* 46 */ 0, {  5, 6, 0, 0 } },
    { /* 47 */ 1, {  2,  0,  2,  1 } }, // 11111111111010
    { /* 48 */ 1, {  2,  1,  1,  2 } }, // 11111111111011
    { /* 49 */ 1, {  2,  1,  0,  2 } }, // 11111111111100
    { /* 50 */ 0, { 3, 4, 0, 0 } },
    { /* 51 */ 0, { 4, 5, 0, 0 } },
    { /* 52 */ 0, { 5, 6, 0, 0 } },
    { /* 53 */ 1, {  2,  2,  2,  2 } }, // 111111111111010
    { /* 54 */ 1, {  2,  2,  1,  2 } }, // 111111111111011
    { /* 55 */ 1, {  2,  1,  2,  2 } }, // 111111111111100
    { /* 56 */ 1, {  2,  0,  1,  2 } }, // 111111111111101
    { /* 57 */ 1, {  2,  0,  0,  2 } }, // 111111111111110
    { /* 58 */ 0, { 1, 2, 0, 0 } },
    { /* 59 */ 1, {  2,  2,  0,  2 } }, // 1111111111111110
    { /* 60 */ 1, {  2,  0,  2,  2 } }  // 1111111111111111
};

const AacHcb aacHcb4Step1[] = {
    // 4 bit codewords
    { /* 00000 */ 0, 0 },
    { /*       */ 0, 0 },
    { /* 00010 */ 1, 0 },
    { /*       */ 1, 0 },
    { /* 00100 */ 2, 0 },
    { /*       */ 2, 0 },
    { /* 00110 */ 3, 0 },
    { /*       */ 3, 0 },
    { /* 01000 */ 4, 0 },
    { /*       */ 4, 0 },
    { /* 01010 */ 5, 0 },
    { /*       */ 5, 0 },
    { /* 01100 */ 6, 0 },
    { /*       */ 6, 0 },
    { /* 01110 */ 7, 0 },
    { /*       */ 7, 0 },
    { /* 10000 */ 8, 0 },
    { /*       */ 8, 0 },
    { /* 10010 */ 9, 0 },
    { /*       */ 9, 0 },

    // 5 bit codewords
    { /* 10100 */ 10, 0 },
    { /* 10101 */ 11, 0 },
    { /* 10110 */ 12, 0 },
    { /* 10111 */ 13, 0 },
    { /* 11000 */ 14, 0 },
    { /* 11001 */ 15, 0 },

    // 7 bit codewords
    { /* 11010 */ 16, 2 },
    { /* 11011 */ 20, 2 },

    // 7/8 bit codewords
    { /* 11100 */ 24, 3 },

    // 8 bit codewords
    { /* 11101 */ 32, 3 },

    // 8/9 bit codewords
    { /* 11110 */ 40, 4 },

    // 9/10/11/12 bit codewords
    { /* 11111 */ 56, 7 }
};

const AacHcb2Quad aacHcb4Step2[] = {
    // 4 bit codewords
    { 4,  1,  1,  1,  1 },
    { 4,  0,  1,  1,  1 },
    { 4,  1,  1,  0,  1 },
    { 4,  1,  1,  1,  0 },
    { 4,  1,  0,  1,  1 },
    { 4,  1,  0,  0,  0 },
    { 4,  1,  1,  0,  0 },
    { 4,  0,  0,  0,  0 },
    { 4,  0,  0,  1,  1 },
    { 4,  1,  0,  1,  0 },

    // 5 bit codewords
    { 5,  1,  0,  0,  1 },
    { 5,  0,  1,  1,  0 },
    { 5,  0,  0,  0,  1 },
    { 5,  0,  1,  0,  1 },
    { 5,  0,  0,  1,  0 },
    { 5,  0,  1,  0,  0 },

    // 7 bit codewords
    // first 5 bits: 11010
    { 7,  2,  1,  1,  1 },
    { 7,  1,  1,  2,  1 },
    { 7,  1,  2,  1,  1 },
    { 7,  1,  1,  1,  2 },
    // first 5 bits: 11011
    { 7,  2,  1,  1,  0 },
    { 7,  2,  1,  0,  1 },
    { 7,  1,  2,  1,  0 },
    { 7,  2,  0,  1,  1 },

    // 7/8 bit codewords
    // first 5 bits: 11100
    { 7,  0,  1,  2,  1 }, { 7,  0,  1,  2,  1 },
    { 8,  0,  1,  1,  2 },
    { 8,  1,  1,  2,  0 },
    { 8,  0,  2,  1,  1 },
    { 8,  1,  0,  1,  2 },
    { 8,  1,  2,  0,  1 },
    { 8,  1,  1,  0,  2 },

    // 8 bit codewords
    { 8,  1,  0,  2,  1 },
    { 8,  2,  1,  0,  0 },
    { 8,  2,  0,  1,  0 },
    { 8,  1,  2,  0,  0 },
    { 8,  2,  0,  0,  1 },
    { 8,  0,  1,  0,  2 },
    { 8,  0,  2,  1,  0 },
    { 8,  0,  0,  1,  2 },

    // 8/9 bit codewords
    { 8,  0,  1,  2,  0 }, { 8,  0,  1,  2,  0 },
    { 8,  0,  2,  0,  1 }, { 8,  0,  2,  0,  1 },
    { 8,  1,  0,  0,  2 }, { 8,  1,  0,  0,  2 },
    { 8,  0,  0,  2,  1 }, { 8,  0,  0,  2,  1 },
    { 8,  1,  0,  2,  0 }, { 8,  1,  0,  2,  0 },
    { 8,  2,  0,  0,  0 }, { 8,  2,  0,  0,  0 },
    { 8,  0,  0,  0,  2 }, { 8,  0,  0,  0,  2 },
    { 9,  0,  2,  0,  0 },
    { 9,  0,  0,  2,  0 },

    // 9/10/11 bit codewords
    // 9 bit codewords repeated 2^3 = 8 times
    { 9,  1,  2,  2,  1 }, { 9,  1,  2,  2,  1 }, { 9,  1,  2,  2,  1 }, { 9,  1,  2,  2,  1 },
    { 9,  1,  2,  2,  1 }, { 9,  1,  2,  2,  1 }, { 9,  1,  2,  2,  1 }, { 9,  1,  2,  2,  1 },
    { 9,  2,  2,  1,  1 }, { 9,  2,  2,  1,  1 }, { 9,  2,  2,  1,  1 }, { 9,  2,  2,  1,  1 },
    { 9,  2,  2,  1,  1 }, { 9,  2,  2,  1,  1 }, { 9,  2,  2,  1,  1 }, { 9,  2,  2,  1,  1 },
    { 9,  2,  1,  2,  1 }, { 9,  2,  1,  2,  1 }, { 9,  2,  1,  2,  1 }, { 9,  2,  1,  2,  1 },
    { 9,  2,  1,  2,  1 }, { 9,  2,  1,  2,  1 }, { 9,  2,  1,  2,  1 }, { 9,  2,  1,  2,  1 },
    { 9,  1,  1,  2,  2 }, { 9,  1,  1,  2,  2 }, { 9,  1,  1,  2,  2 }, { 9,  1,  1,  2,  2 },
    { 9,  1,  1,  2,  2 }, { 9,  1,  1,  2,  2 }, { 9,  1,  1,  2,  2 }, { 9,  1,  1,  2,  2 },
    { 9,  1,  2,  1,  2 }, { 9,  1,  2,  1,  2 }, { 9,  1,  2,  1,  2 }, { 9,  1,  2,  1,  2 },
    { 9,  1,  2,  1,  2 }, { 9,  1,  2,  1,  2 }, { 9,  1,  2,  1,  2 }, { 9,  1,  2,  1,  2 },
    { 9,  2,  1,  1,  2 }, { 9,  2,  1,  1,  2 }, { 9,  2,  1,  1,  2 }, { 9,  2,  1,  1,  2 },
    { 9,  2,  1,  1,  2 }, { 9,  2,  1,  1,  2 }, { 9,  2,  1,  1,  2 }, { 9,  2,  1,  1,  2 },
    // 10 bit codewords repeated 2^2 = 4 times
    { 10,  1,  2,  2,  0 }, { 10,  1,  2,  2,  0 }, { 10,  1,  2,  2,  0 }, { 10,  1,  2,  2,  0 },
    { 10,  2,  2,  1,  0 }, { 10,  2,  2,  1,  0 }, { 10,  2,  2,  1,  0 }, { 10,  2,  2,  1,  0 },
    { 10,  2,  1,  2,  0 }, { 10,  2,  1,  2,  0 }, { 10,  2,  1,  2,  0 }, { 10,  2,  1,  2,  0 },
    { 10,  0,  2,  2,  1 }, { 10,  0,  2,  2,  1 }, { 10,  0,  2,  2,  1 }, { 10,  0,  2,  2,  1 },
    { 10,  0,  1,  2,  2 }, { 10,  0,  1,  2,  2 }, { 10,  0,  1,  2,  2 }, { 10,  0,  1,  2,  2 },
    { 10,  2,  2,  0,  1 }, { 10,  2,  2,  0,  1 }, { 10,  2,  2,  0,  1 }, { 10,  2,  2,  0,  1 },
    { 10,  0,  2,  1,  2 }, { 10,  0,  2,  1,  2 }, { 10,  0,  2,  1,  2 }, { 10,  0,  2,  1,  2 },
    { 10,  2,  0,  2,  1 }, { 10,  2,  0,  2,  1 }, { 10,  2,  0,  2,  1 }, { 10,  2,  0,  2,  1 },
    { 10,  1,  0,  2,  2 }, { 10,  1,  0,  2,  2 }, { 10,  1,  0,  2,  2 }, { 10,  1,  0,  2,  2 },
    { 10,  2,  2,  2,  1 }, { 10,  2,  2,  2,  1 }, { 10,  2,  2,  2,  1 }, { 10,  2,  2,  2,  1 },
    { 10,  1,  2,  0,  2 }, { 10,  1,  2,  0,  2 }, { 10,  1,  2,  0,  2 }, { 10,  1,  2,  0,  2 },
    { 10,  2,  0,  1,  2 }, { 10,  2,  0,  1,  2 }, { 10,  2,  0,  1,  2 }, { 10,  2,  0,  1,  2 },
    { 10,  2,  1,  0,  2 }, { 10,  2,  1,  0,  2 }, { 10,  2,  1,  0,  2 }, { 10,  2,  1,  0,  2 },
    { 10,  1,  2,  2,  2 }, { 10,  1,  2,  2,  2 }, { 10,  1,  2,  2,  2 }, { 10,  1,  2,  2,  2 },
    // 11 bit codewords repeated 2^1 = 2 times
    { 11,  2,  1,  2,  2 }, { 11,  2,  1,  2,  2 },
    { 11,  2,  2,  1,  2 }, { 11,  2,  2,  1,  2 },
    { 11,  0,  2,  2,  0 }, { 11,  0,  2,  2,  0 },
    { 11,  2,  2,  0,  0 }, { 11,  2,  2,  0,  0 },
    { 11,  0,  0,  2,  2 }, { 11,  0,  0,  2,  2 },
    { 11,  2,  0,  2,  0 }, { 11,  2,  0,  2,  0 },
    { 11,  0,  2,  0,  2 }, { 11,  0,  2,  0,  2 },
    { 11,  2,  0,  0,  2 }, { 11,  2,  0,  0,  2 },
    { 11,  2,  2,  2,  2 }, { 11,  2,  2,  2,  2 },
    { 11,  0,  2,  2,  2 }, { 11,  0,  2,  2,  2 },
    { 11,  2,  2,  2,  0 }, { 11,  2,  2,  2,  0 },
    // 12 bit codewords
    { 12,  2,  2,  0,  2 },
    { 12,  2,  0,  2,  2 },
};

const AacHcbBinPair aacHcb5[] = {
    { /*  0 */ 0, {  1,  2 } },
    { /*  1 */ 1, {  0,  0 } }, // 0
    { /*  2 */ 0, {  1,  2 } },
    { /*  3 */ 0, {  2,  3 } },
    { /*  4 */ 0, {  3,  4 } },
    { /*  5 */ 0, {  4,  5 } },
    { /*  6 */ 0, {  5,  6 } },
    { /*  7 */ 0, {  6,  7 } },
    { /*  8 */ 0, {  7,  8 } },
    { /*  9 */ 1, { -1,  0 } }, // 1000
    { /* 10 */ 1, {  1,  0 } }, // 1001
    { /* 11 */ 1, {  0,  1 } }, // 1010
    { /* 12 */ 1, {  0, -1 } }, // 1011
    { /* 13 */ 0, {  4,  5 } },
    { /* 14 */ 0, {  5,  6 } },
    { /* 15 */ 0, {  6,  7 } },
    { /* 16 */ 0, {  7,  8 } },
    { /* 17 */ 1, {  1, -1 } },
    { /* 18 */ 1, { -1,  1 } },
    { /* 19 */ 1, { -1, -1 } },
    { /* 20 */ 1, {  1,  1 } },
    { /* 21 */ 0, {  4,  5 } },
    { /* 22 */ 0, {  5,  6 } },
    { /* 23 */ 0, {  6,  7 } },
    { /* 24 */ 0, {  7,  8 } },
    { /* 25 */ 0, {  8,  9 } },
    { /* 26 */ 0, {  9, 10 } },
    { /* 27 */ 0, { 10, 11 } },
    { /* 28 */ 0, { 11, 12 } },
    { /* 29 */ 0, { 12, 13 } },
    { /* 30 */ 0, { 13, 14 } },
    { /* 31 */ 0, { 14, 15 } },
    { /* 32 */ 0, { 15, 16 } },
    { /* 33 */ 1, { -2,  0 } },
    { /* 34 */ 1, {  0,  2 } },
    { /* 35 */ 1, {  2,  0 } },
    { /* 36 */ 1, {  0, -2 } },
    { /* 37 */ 0, { 12, 13 } },
    { /* 38 */ 0, { 13, 14 } },
    { /* 39 */ 0, { 14, 15 } },
    { /* 40 */ 0, { 15, 16 } },
    { /* 41 */ 0, { 16, 17 } },
    { /* 42 */ 0, { 17, 18 } },
    { /* 43 */ 0, { 18, 19 } },
    { /* 44 */ 0, { 19, 20 } },
    { /* 45 */ 0, { 20, 21 } },
    { /* 46 */ 0, { 21, 22 } },
    { /* 47 */ 0, { 22, 23 } },
    { /* 48 */ 0, { 23, 24 } },
    { /* 49 */ 1, { -2, -1 } },
    { /* 50 */ 1, {  2,  1 } },
    { /* 51 */ 1, { -1, -2 } },
    { /* 52 */ 1, {  1,  2 } },
    { /* 53 */ 1, { -2,  1 } },
    { /* 54 */ 1, {  2, -1 } },
    { /* 55 */ 1, { -1,  2 } },
    { /* 56 */ 1, {  1, -2 } },
    { /* 57 */ 1, { -3,  0 } },
    { /* 58 */ 1, {  3,  0 } },
    { /* 59 */ 1, {  0, -3 } },
    { /* 60 */ 1, {  0,  3 } },
    { /* 61 */ 0, { 12, 13 } },
    { /* 62 */ 0, { 13, 14 } },
    { /* 63 */ 0, { 14, 15 } },
    { /* 64 */ 0, { 15, 16 } },
    { /* 65 */ 0, { 16, 17 } },
    { /* 66 */ 0, { 17, 18 } },
    { /* 67 */ 0, { 18, 19 } },
    { /* 68 */ 0, { 19, 20 } },
    { /* 69 */ 0, { 20, 21 } },
    { /* 70 */ 0, { 21, 22 } },
    { /* 71 */ 0, { 22, 23 } },
    { /* 72 */ 0, { 23, 24 } },
    { /* 73 */ 1, { -3, -1 } },
    { /* 74 */ 1, {  1,  3 } },
    { /* 75 */ 1, {  3,  1 } },
    { /* 76 */ 1, { -1, -3 } },
    { /* 77 */ 1, { -3,  1 } },
    { /* 78 */ 1, {  3, -1 } },
    { /* 79 */ 1, {  1, -3 } },
    { /* 80 */ 1, { -1,  3 } },
    { /* 81 */ 1, { -2,  2 } },
    { /* 82 */ 1, {  2,  2 } },
    { /* 83 */ 1, { -2, -2 } },
    { /* 84 */ 1, {  2, -2 } },
    { /* 85 */ 0, { 12, 13 } },
    { /* 86 */ 0, { 13, 14 } },
    { /* 87 */ 0, { 14, 15 } },
    { /* 88 */ 0, { 15, 16 } },
    { /* 89 */ 0, { 16, 17 } },
    { /* 90 */ 0, { 17, 18 } },
    { /* 91 */ 0, { 18, 19 } },
    { /* 92 */ 0, { 19, 20 } },
    { /* 93 */ 0, { 20, 21 } },
    { /* 94 */ 0, { 21, 22 } },
    { /* 95 */ 0, { 22, 23 } },
    { /* 96 */ 0, { 23, 24 } },
    { /* 97 */ 1, { -3, -2 } },
    { /* 98 */ 1, {  3, -2 } },
    { /* 99 */ 1, { -2,  3 } },
    { /* 00 */ 1, {  2, -3 } },
    { /* 01 */ 1, {  3,  2 } },
    { /* 02 */ 1, {  2,  3 } },
    { /* 03 */ 1, { -3,  2 } },
    { /* 04 */ 1, { -2, -3 } },
    { /* 05 */ 1, {  0, -4 } },
    { /* 06 */ 1, { -4,  0 } },
    { /* 07 */ 1, {  4,  1 } },
    { /* 08 */ 1, {  4,  0 } },
    { /* 09 */ 0, { 12, 13 } },
    { /* 10 */ 0, { 13, 14 } },
    { /* 11 */ 0, { 14, 15 } },
    { /* 12 */ 0, { 15, 16 } },
    { /* 13 */ 0, { 16, 17 } },
    { /* 14 */ 0, { 17, 18 } },
    { /* 15 */ 0, { 18, 19 } },
    { /* 16 */ 0, { 19, 20 } },
    { /* 17 */ 0, { 20, 21 } },
    { /* 18 */ 0, { 21, 22 } },
    { /* 19 */ 0, { 22, 23 } },
    { /* 20 */ 0, { 23, 24 } },
    { /* 21 */ 1, { -4, -1 } },
    { /* 22 */ 1, {  0,  4 } },
    { /* 23 */ 1, {  4, -1 } },
    { /* 24 */ 1, { -1, -4 } },
    { /* 25 */ 1, {  1,  4 } },
    { /* 26 */ 1, { -1,  4 } },
    { /* 27 */ 1, { -4,  1 } },
    { /* 28 */ 1, {  1, -4 } },
    { /* 29 */ 1, {  3, -3 } },
    { /* 30 */ 1, { -3, -3 } },
    { /* 31 */ 1, { -3,  3 } },
    { /* 32 */ 1, { -2,  4 } },
    { /* 33 */ 1, { -4, -2 } },
    { /* 34 */ 1, {  4,  2 } },
    { /* 35 */ 1, {  2, -4 } },
    { /* 36 */ 1, {  2,  4 } },
    { /* 37 */ 1, {  3,  3 } },
    { /* 38 */ 1, { -4,  2 } },
    { /* 39 */ 0, { 6, 7 } },
    { /* 40 */ 0, { 7, 8 } },
    { /* 41 */ 0, { 8, 9 } },
    { /* 42 */ 0, { 9, 10 } },
    { /* 43 */ 0, { 10, 11 } },
    { /* 44 */ 0, { 11, 12 } },
    { /* 45 */ 1, { -2, -4 } },
    { /* 46 */ 1, {  4, -2 } },
    { /* 47 */ 1, {  3, -4 } },
    { /* 48 */ 1, { -4, -3 } },
    { /* 49 */ 1, { -4,  3 } },
    { /* 50 */ 1, {  3,  4 } },
    { /* 51 */ 1, { -3,  4 } },
    { /* 52 */ 1, {  4,  3 } },
    { /* 53 */ 1, {  4, -3 } },
    { /* 54 */ 1, { -3, -4 } },
    { /* 55 */ 0, { 2, 3 } },
    { /* 56 */ 0, { 3, 4 } },
    { /* 57 */ 1, {  4, -4 } },
    { /* 58 */ 1, { -4,  4 } },
    { /* 59 */ 1, {  4,  4 } },
    { /* 60 */ 1, { -4, -4 } }
};

const AacHcb aacHcb6Step1[] = {
    // 4 bit codewords
    { /* 00000 */ 0, 0 },
    { /*       */ 0, 0 },
    { /* 00010 */ 1, 0 },
    { /*       */ 1, 0 },
    { /* 00100 */ 2, 0 },
    { /*       */ 2, 0 },
    { /* 00110 */ 3, 0 },
    { /*       */ 3, 0 },
    { /* 01000 */ 4, 0 },
    { /*       */ 4, 0 },
    { /* 01010 */ 5, 0 },
    { /*       */ 5, 0 },
    { /* 01100 */ 6, 0 },
    { /*       */ 6, 0 },
    { /* 01110 */ 7, 0 },
    { /*       */ 7, 0 },
    { /* 10000 */ 8, 0 },
    { /*       */ 8, 0 },

    // 6 bit codewords
    { /* 10010 */ 9, 1 },
    { /* 10011 */ 11, 1 },
    { /* 10100 */ 13, 1 },
    { /* 10101 */ 15, 1 },
    { /* 10110 */ 17, 1 },
    { /* 10111 */ 19, 1 },
    { /* 11000 */ 21, 1 },
    { /* 11001 */ 23, 1 },

    // 7 bit codewords
    { /* 11010 */ 25, 2 },
    { /* 11011 */ 29, 2 },
    { /* 11100 */ 33, 2 },

    // 7/8 bit codewords
    { /* 11101 */ 37, 3 },

    // 8/9 bit codewords
    { /* 11110 */ 45, 4 },

    // 9/10/11 bit codewords
    { /* 11111 */ 61, 6 }
};

const AacHcb2Pair aacHcb6Step2[] = {
    // 4 bit codewords
    { 4,  0,  0 },
    { 4,  1,  0 },
    { 4,  0, -1 },
    { 4,  0,  1 },
    { 4, -1,  0 },
    { 4,  1,  1 },
    { 4, -1,  1 },
    { 4,  1, -1 },
    { 4, -1, -1 },

    // 6 bit codewords
    { 6,  2, -1 },
    { 6,  2,  1 },
    { 6, -2,  1 },
    { 6, -2, -1 },
    { 6, -2,  0 },
    { 6, -1,  2 },
    { 6,  2,  0 },
    { 6,  1, -2 },
    { 6,  1,  2 },
    { 6,  0, -2 },
    { 6, -1, -2 },
    { 6,  0,  2 },
    { 6,  2, -2 },
    { 6, -2,  2 },
    { 6, -2, -2 },
    { 6,  2,  2 },

    // 7 bit codewords
    { 7, -3,  1 },
    { 7,  3,  1 },
    { 7,  3, -1 },
    { 7, -1,  3 },
    { 7, -3, -1 },
    { 7,  1,  3 },
    { 7,  1, -3 },
    { 7, -1, -3 },
    { 7,  3,  0 },
    { 7, -3,  0 },
    { 7,  0, -3 },
    { 7,  0,  3 },

    // 7/8 bit codewords
    { 7,  3,  2 }, { 7,  3,  2 },
    { 8, -3, -2 },
    { 8, -2,  3 },
    { 8,  2,  3 },
    { 8,  3, -2 },
    { 8,  2, -3 },
    { 8, -2, -3 },

    // 8 bit codewords
    { 8, -3,  2 }, { 8, -3,  2 },
    { 8,  3,  3 }, { 8,  3,  3 },
    { 9,  3, -3 },
    { 9, -3, -3 },
    { 9, -3,  3 },
    { 9,  1, -4 },
    { 9, -1, -4 },
    { 9,  4,  1 },
    { 9, -4,  1 },
    { 9, -4, -1 },
    { 9,  1,  4 },
    { 9,  4, -1 },
    { 9, -1,  4 },
    { 9,  0, -4 },

    // 9/10/11 bit codewords
    { 9, -4,  2 }, { 9, -4,  2 }, { 9, -4,  2 }, { 9, -4,  2 },
    { 9, -4, -2 }, { 9, -4, -2 }, { 9, -4, -2 }, { 9, -4, -2 },
    { 9,  2,  4 }, { 9,  2,  4 }, { 9,  2,  4 }, { 9,  2,  4 },
    { 9, -2, -4 }, { 9, -2, -4 }, { 9, -2, -4 }, { 9, -2, -4 },
    { 9, -4,  0 }, { 9, -4,  0 }, { 9, -4,  0 }, { 9, -4,  0 },
    { 9,  4,  2 }, { 9,  4,  2 }, { 9,  4,  2 }, { 9,  4,  2 },
    { 9,  4, -2 }, { 9,  4, -2 }, { 9,  4, -2 }, { 9,  4, -2 },
    { 9, -2,  4 }, { 9, -2,  4 }, { 9, -2,  4 }, { 9, -2,  4 },
    { 9,  4,  0 }, { 9,  4,  0 }, { 9,  4,  0 }, { 9,  4,  0 },
    { 9,  2, -4 }, { 9,  2, -4 }, { 9,  2, -4 }, { 9,  2, -4 },
    { 9,  0,  4 }, { 9,  0,  4 }, { 9,  0,  4 }, { 9,  0,  4 },
    { 10, -3, -4 }, { 10, -3, -4 },
    { 10, -3,  4 }, { 10, -3,  4 },
    { 10,  3, -4 }, { 10,  3, -4 },
    { 10,  4, -3 }, { 10,  4, -3 },
    { 10,  3,  4 }, { 10,  3,  4 },
    { 10,  4,  3 }, { 10,  4,  3 },
    { 10, -4,  3 }, { 10, -4,  3 },
    { 10, -4, -3 }, { 10, -4, -3 },
    { 11,  4,  4 },
    { 11, -4,  4 },
    { 11, -4, -4 },
    { 11,  4, -4 }
};

const AacHcbBinPair aacHcb7[] = {
    { /*  0 */ 0, { 1, 2 } },
    { /*  1 */ 1, { 0, 0 } },
    { /*  2 */ 0, { 1, 2 } },
    { /*  3 */ 0, { 2, 3 } },
    { /*  4 */ 0, { 3, 4 } },
    { /*  5 */ 1, { 1, 0 } },
    { /*  6 */ 1, { 0, 1 } },
    { /*  7 */ 0, { 2, 3 } },
    { /*  8 */ 0, { 3, 4 } },
    { /*  9 */ 1, { 1,  1 } },
    { /* 10 */ 0, { 3, 4 } },
    { /* 11 */ 0, { 4, 5 } },
    { /* 12 */ 0, { 5, 6 } },
    { /* 13 */ 0, { 6, 7 } },
    { /* 14 */ 0, { 7, 8 } },
    { /* 15 */ 0, { 8, 9 } },
    { /* 16 */ 0, { 9, 10 } },
    { /* 17 */ 0, { 10, 11 } },
    { /* 18 */ 0, { 11, 12 } },
    { /* 19 */ 1, { 2,  1 } },
    { /* 20 */ 1, { 1,  2 } },
    { /* 21 */ 1, { 2,  0 } },
    { /* 22 */ 1, { 0,  2 } },
    { /* 23 */ 0, { 8, 9 } },
    { /* 24 */ 0, { 9, 10 } },
    { /* 25 */ 0, { 10, 11 } },
    { /* 26 */ 0, { 11, 12 } },
    { /* 27 */ 0, { 12, 13 } },
    { /* 28 */ 0, { 13, 14 } },
    { /* 29 */ 0, { 14, 15 } },
    { /* 30 */ 0, { 15, 16 } },
    { /* 31 */ 1, { 3,  1 } },
    { /* 32 */ 1, { 1,  3 } },
    { /* 33 */ 1, { 2,  2 } },
    { /* 34 */ 1, { 3,  0 } },
    { /* 35 */ 1, { 0,  3 } },
    { /* 36 */ 0, { 11, 12 } },
    { /* 37 */ 0, { 12, 13 } },
    { /* 38 */ 0, { 13, 14 } },
    { /* 39 */ 0, { 14, 15 } },
    { /* 40 */ 0, { 15, 16 } },
    { /* 41 */ 0, { 16, 17 } },
    { /* 42 */ 0, { 17, 18 } },
    { /* 43 */ 0, { 18, 19 } },
    { /* 44 */ 0, { 19, 20 } },
    { /* 45 */ 0, { 20, 21 } },
    { /* 46 */ 0, { 21, 22 } },
    { /* 47 */ 1, { 2,  3 } },
    { /* 48 */ 1, { 3,  2 } },
    { /* 49 */ 1, { 1,  4 } },
    { /* 50 */ 1, { 4,  1 } },
    { /* 51 */ 1, { 1,  5 } },
    { /* 52 */ 1, { 5,  1 } },
    { /* 53 */ 1, { 3,  3 } },
    { /* 54 */ 1, { 2,  4 } },
    { /* 55 */ 1, { 0,  4 } },
    { /* 56 */ 1, { 4,  0 } },
    { /* 57 */ 0, { 12, 13 } },
    { /* 58 */ 0, { 13, 14 } },
    { /* 59 */ 0, { 14, 15 } },
    { /* 60 */ 0, { 15, 16 } },
    { /* 61 */ 0, { 16, 17 } },
    { /* 62 */ 0, { 17, 18 } },
    { /* 63 */ 0, { 18, 19 } },
    { /* 64 */ 0, { 19, 20 } },
    { /* 65 */ 0, { 20, 21 } },
    { /* 66 */ 0, { 21, 22 } },
    { /* 67 */ 0, { 22, 23 } },
    { /* 68 */ 0, { 23, 24 } },
    { /* 69 */ 1, { 4,  2 } },
    { /* 70 */ 1, { 2,  5 } },
    { /* 71 */ 1, { 5,  2 } },
    { /* 72 */ 1, { 0,  5 } },
    { /* 73 */ 1, { 6,  1 } },
    { /* 74 */ 1, { 5,  0 } },
    { /* 75 */ 1, { 1,  6 } },
    { /* 76 */ 1, { 4,  3 } },
    { /* 77 */ 1, { 3,  5 } },
    { /* 78 */ 1, { 3,  4 } },
    { /* 79 */ 1, { 5,  3 } },
    { /* 80 */ 1, { 2,  6 } },
    { /* 81 */ 1, { 6,  2 } },
    { /* 82 */ 1, { 1,  7 } },
    { /* 83 */ 0, { 10, 11 } },
    { /* 84 */ 0, { 11, 12 } },
    { /* 85 */ 0, { 12, 13 } },
    { /* 86 */ 0, { 13, 14 } },
    { /* 87 */ 0, { 14, 15 } },
    { /* 88 */ 0, { 15, 16 } },
    { /* 89 */ 0, { 16, 17 } },
    { /* 90 */ 0, { 17, 18 } },
    { /* 91 */ 0, { 18, 19 } },
    { /* 92 */ 0, { 19, 20 } },
    { /* 93 */ 1, { 3,  6 } },
    { /* 94 */ 1, { 0,  6 } },
    { /* 95 */ 1, { 6,  0 } },
    { /* 96 */ 1, { 4,  4 } },
    { /* 97 */ 1, { 7,  1 } },
    { /* 98 */ 1, { 4,  5 } },
    { /* 99 */ 1, { 7,  2 } },
    { /* 00 */ 1, { 5,  4 } },
    { /* 01 */ 1, { 6,  3 } },
    { /* 02 */ 1, { 2,  7 } },
    { /* 03 */ 1, { 7,  3 } },
    { /* 04 */ 1, { 6,  4 } },
    { /* 05 */ 1, { 5,  5 } },
    { /* 06 */ 1, { 4,  6 } },
    { /* 07 */ 1, { 3,  7 } },
    { /* 08 */ 0, { 5, 6 } },
    { /* 09 */ 0, { 6, 7 } },
    { /* 10 */ 0, { 7, 8 } },
    { /* 11 */ 0, { 8, 9 } },
    { /* 12 */ 0, { 9, 10 } },
    { /* 13 */ 1, { 7,  0 } },
    { /* 14 */ 1, { 0,  7 } },
    { /* 15 */ 1, { 6,  5 } },
    { /* 16 */ 1, { 5,  6 } },
    { /* 17 */ 1, { 7,  4 } },
    { /* 18 */ 1, { 4,  7 } },
    { /* 19 */ 1, { 5,  7 } },
    { /* 20 */ 1, { 7,  5 } },
    { /* 21 */ 0, { 2, 3 } },
    { /* 22 */ 0, { 3, 4 } },
    { /* 23 */ 1, { 7,  6 } },
    { /* 24 */ 1, { 6,  6 } },
    { /* 25 */ 1, { 6,  7 } },
    { /* 26 */ 1, { 7,  7 } }
};

const AacHcb aacHcb8Step1[] = {
    // 3 bit codeword
    { /* 00000 */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },
    { /*       */ 0, 0 },

    // 4 bit codewords
    { /* 00100 */ 1, 0 },
    { /*       */ 1, 0 },
    { /* 00110 */ 2, 0 },
    { /*       */ 2, 0 },
    { /* 01000 */ 3, 0 },
    { /*       */ 3, 0 },
    { /* 01010 */ 4, 0 },
    { /*       */ 4, 0 },
    { /* 01100 */ 5, 0 },
    { /*       */ 5, 0 },

    // 5 bit codewords
    { /* 01110 */ 6, 0 },
    { /* 01111 */ 7, 0 },
    { /* 10000 */ 8, 0 },
    { /* 10001 */ 9, 0 },
    { /* 10010 */ 10, 0 },
    { /* 10011 */ 11, 0 },
    { /* 10100 */ 12, 0 },

    // 6 bit codewords
    { /* 10101 */ 13, 1 },
    { /* 10110 */ 15, 1 },
    { /* 10111 */ 17, 1 },
    { /* 11000 */ 19, 1 },
    { /* 11001 */ 21, 1 },

    // 7 bit codewords
    { /* 11010 */ 23, 2 },
    { /* 11011 */ 27, 2 },
    { /* 11100 */ 31, 2 },

    // 7/8 bit codewords
    { /* 11101 */ 35, 3 },

    // 8 bit codewords
    { /* 11110 */ 43, 3 },

    // 8/9/10 bit codewords
    { /* 11111 */ 51, 5 }
};

const AacHcb2Pair aacHcb8Step2[] = {
    // 3 bit codeword
    { 3,  1,  1 },

    // 4 bit codewords
    { 4,  2,  1 },
    { 4,  1,  0 },
    { 4,  1,  2 },
    { 4,  0,  1 },
    { 4,  2,  2 },

    // 5 bit codewords
    { 5,  0,  0 },
    { 5,  2,  0 },
    { 5,  0,  2 },
    { 5,  3,  1 },
    { 5,  1,  3 },
    { 5,  3,  2 },
    { 5,  2,  3 },

    // 6 bit codewords
    { 6,  3,  3 },
    { 6,  4,  1 },
    { 6,  1,  4 },
    { 6,  4,  2 },
    { 6,  2,  4 },
    { 6,  3,  0 },
    { 6,  0,  3 },
    { 6,  4,  3 },
    { 6,  3,  4 },
    { 6,  5,  2 },

    // 7 bit codewords
    { 7,  5,  1 },
    { 7,  2,  5 },
    { 7,  1,  5 },
    { 7,  5,  3 },
    { 7,  3,  5 },
    { 7,  4,  4 },
    { 7,  5,  4 },
    { 7,  0,  4 },
    { 7,  4,  5 },
    { 7,  4,  0 },
    { 7,  2,  6 },
    { 7,  6,  2 },

    // 7/8 bit codewords
    { 7,  6,  1 }, { 7,  6,  1 },
    { 7,  1,  6 }, { 7,  1,  6 },
    { 8,  3,  6 },
    { 8,  6,  3 },
    { 8,  5,  5 },
    { 8,  5,  0 },

    // 8 bit codewords
    { 8,  6,  4 },
    { 8,  0,  5 },
    { 8,  4,  6 },
    { 8,  7,  1 },
    { 8,  7,  2 },
    { 8,  2,  7 },
    { 8,  6,  5 },
    { 8,  7,  3 },

    // 8/9/10 bit codewords
    { 8,  1,  7 }, { 8,  1,  7 }, { 8,  1,  7 }, { 8,  1,  7 },
    { 8,  5,  6 }, { 8,  5,  6 }, { 8,  5,  6 }, { 8,  5,  6 },
    { 8,  3,  7 }, { 8,  3,  7 }, { 8,  3,  7 }, { 8,  3,  7 },
    { 9,  6,  6 }, { 9,  6,  6 },
    { 9,  7,  4 }, { 9,  7,  4 },
    { 9,  6,  0 }, { 9,  6,  0 },
    { 9,  4,  7 }, { 9,  4,  7 },
    { 9,  0,  6 }, { 9,  0,  6 },
    { 9,  7,  5 }, { 9,  7,  5 },
    { 9,  7,  6 }, { 9,  7,  6 },
    { 9,  6,  7 }, { 9,  6,  7 },
    { 10,  5,  7 },
    { 10,  7,  0 },
    { 10,  0,  7 },
    { 10,  7,  7 }
};

const AacHcbBinPair aacHcb9[] = {
    { /*  0 */ 0, { 1, 2 } },
    { /*  1 */ 1, { 0, 0 } },
    { /*  2 */ 0, { 1, 2 } },
    { /*  3 */ 0, { 2, 3 } },
    { /*  4 */ 0, { 3, 4 } },
    { /*  5 */ 1, { 1,  0 } },
    { /*  6 */ 1, { 0,  1 } },
    { /*  7 */ 0, { 2, 3 } },
    { /*  8 */ 0, { 3, 4 } },
    { /*  9 */ 1, { 1,  1 } },
    { /* 10 */ 0, { 3, 4 } },
    { /* 11 */ 0, { 4, 5 } },
    { /* 12 */ 0, { 5, 6 } },
    { /* 13 */ 0, { 6, 7 } },
    { /* 14 */ 0, { 7, 8 } },
    { /* 15 */ 0, { 8, 9 } },
    { /* 16 */ 0, { 9, 10 } },
    { /* 17 */ 0, { 10, 11 } },
    { /* 18 */ 0, { 11, 12 } },
    { /* 19 */ 1, { 2,  1 } },
    { /* 20 */ 1, { 1,  2 } },
    { /* 21 */ 1, { 2,  0 } },
    { /* 22 */ 1, { 0,  2 } },
    { /* 23 */ 0, { 8, 9 } },
    { /* 24 */ 0, { 9, 10 } },
    { /* 25 */ 0, { 10, 11 } },
    { /* 26 */ 0, { 11, 12 } },
    { /* 27 */ 0, { 12, 13 } },
    { /* 28 */ 0, { 13, 14 } },
    { /* 29 */ 0, { 14, 15 } },
    { /* 30 */ 0, { 15, 16 } },
    { /* 31 */ 1, { 3,  1 } },
    { /* 32 */ 1, { 2,  2 } },
    { /* 33 */ 1, { 1,  3 } },
    { /* 34 */ 0, { 13, 14 } },
    { /* 35 */ 0, { 14, 15 } },
    { /* 36 */ 0, { 15, 16 } },
    { /* 37 */ 0, { 16, 17 } },
    { /* 38 */ 0, { 17, 18 } },
    { /* 39 */ 0, { 18, 19 } },
    { /* 40 */ 0, { 19, 20 } },
    { /* 41 */ 0, { 20, 21 } },
    { /* 42 */ 0, { 21, 22 } },
    { /* 43 */ 0, { 22, 23 } },
    { /* 44 */ 0, { 23, 24 } },
    { /* 45 */ 0, { 24, 25 } },
    { /* 46 */ 0, { 25, 26 } },
    { /* 47 */ 1, { 3,  0 } },
    { /* 48 */ 1, { 0,  3 } },
    { /* 49 */ 1, { 2,  3 } },
    { /* 50 */ 1, { 3,  2 } },
    { /* 51 */ 1, { 1,  4 } },
    { /* 52 */ 1, { 4,  1 } },
    { /* 53 */ 1, { 2,  4 } },
    { /* 54 */ 1, { 1,  5 } },
    { /* 55 */ 0, { 18, 19 } },
    { /* 56 */ 0, { 19, 20 } },
    { /* 57 */ 0, { 20, 21 } },
    { /* 58 */ 0, { 21, 22 } },
    { /* 59 */ 0, { 22, 23 } },
    { /* 60 */ 0, { 23, 24 } },
    { /* 61 */ 0, { 24, 25 } },
    { /* 62 */ 0, { 25, 26 } },
    { /* 63 */ 0, { 26, 27 } },
    { /* 64 */ 0, { 27, 28 } },
    { /* 65 */ 0, { 28, 29 } },
    { /* 66 */ 0, { 29, 30 } },
    { /* 67 */ 0, { 30, 31 } },
    { /* 68 */ 0, { 31, 32 } },
    { /* 69 */ 0, { 32, 33 } },
    { /* 70 */ 0, { 33, 34 } },
    { /* 71 */ 0, { 34, 35 } },
    { /* 72 */ 0, { 35, 36 } },
    { /* 73 */ 1, { 4,  2 } },
    { /* 74 */ 1, { 3,  3 } },
    { /* 75 */ 1, { 0,  4 } },
    { /* 76 */ 1, { 4,  0 } },
    { /* 77 */ 1, { 5,  1 } },
    { /* 78 */ 1, { 2,  5 } },
    { /* 79 */ 1, { 1,  6 } },
    { /* 80 */ 1, { 3,  4 } },
    { /* 81 */ 1, { 5,  2 } },
    { /* 82 */ 1, { 6,  1 } },
    { /* 83 */ 1, { 4,  3 } },
    { /* 84 */ 0, { 25, 26 } },
    { /* 85 */ 0, { 26, 27 } },
    { /* 86 */ 0, { 27, 28 } },
    { /* 87 */ 0, { 28, 29 } },
    { /* 88 */ 0, { 29, 30 } },
    { /* 89 */ 0, { 30, 31 } },
    { /* 90 */ 0, { 31, 32 } },
    { /* 91 */ 0, { 32, 33 } },
    { /* 92 */ 0, { 33, 34 } },
    { /* 93 */ 0, { 34, 35 } },
    { /* 94 */ 0, { 35, 36 } },
    { /* 95 */ 0, { 36, 37 } },
    { /* 96 */ 0, { 37, 38 } },
    { /* 97 */ 0, { 38, 39 } },
    { /* 98 */ 0, { 39, 40 } },
    { /* 99 */ 0, { 40, 41 } },
    { /* 00 */ 0, { 41, 42 } },
    { /* 01 */ 0, { 42, 43 } },
    { /* 02 */ 0, { 43, 44 } },
    { /* 03 */ 0, { 44, 45 } },
    { /* 04 */ 0, { 45, 46 } },
    { /* 05 */ 0, { 46, 47 } },
    { /* 06 */ 0, { 47, 48 } },
    { /* 07 */ 0, { 48, 49 } },
    { /* 08 */ 0, { 49, 50 } },
    { /* 09 */ 1, { 0,  5 } },
    { /* 10 */ 1, { 2,  6 } },
    { /* 11 */ 1, { 5,  0 } },
    { /* 12 */ 1, { 1,  7 } },
    { /* 13 */ 1, { 3,  5 } },
    { /* 14 */ 1, { 1,  8 } },
    { /* 15 */ 1, { 8,  1 } },
    { /* 16 */ 1, { 4,  4 } },
    { /* 17 */ 1, { 5,  3 } },
    { /* 18 */ 1, { 6,  2 } },
    { /* 19 */ 1, { 7,  1 } },
    { /* 20 */ 1, { 0,  6 } },
    { /* 21 */ 1, { 8,  2 } },
    { /* 22 */ 1, { 2,  8 } },
    { /* 23 */ 1, { 3,  6 } },
    { /* 24 */ 1, { 2,  7 } },
    { /* 25 */ 1, { 4,  5 } },
    { /* 26 */ 1, { 9,  1 } },
    { /* 27 */ 1, { 1,  9 } },
    { /* 28 */ 1, { 7,  2 } },
    { /* 29 */ 0, { 30, 31 } },
    { /* 30 */ 0, { 31, 32 } },
    { /* 31 */ 0, { 32, 33 } },
    { /* 32 */ 0, { 33, 34 } },
    { /* 33 */ 0, { 34, 35 } },
    { /* 34 */ 0, { 35, 36 } },
    { /* 35 */ 0, { 36, 37 } },
    { /* 36 */ 0, { 37, 38 } },
    { /* 37 */ 0, { 38, 39 } },
    { /* 38 */ 0, { 39, 40 } },
    { /* 39 */ 0, { 40, 41 } },
    { /* 40 */ 0, { 41, 42 } },
    { /* 41 */ 0, { 42, 43 } },
    { /* 42 */ 0, { 43, 44 } },
    { /* 43 */ 0, { 44, 45 } },
    { /* 44 */ 0, { 45, 46 } },
    { /* 45 */ 0, { 46, 47 } },
    { /* 46 */ 0, { 47, 48 } },
    { /* 47 */ 0, { 48, 49 } },
    { /* 48 */ 0, { 49, 50 } },
    { /* 49 */ 0, { 50, 51 } },
    { /* 50 */ 0, { 51, 52 } },
    { /* 51 */ 0, { 52, 53 } },
    { /* 52 */ 0, { 53, 54 } },
    { /* 53 */ 0, { 54, 55 } },
    { /* 54 */ 0, { 55, 56 } },
    { /* 55 */ 0, { 56, 57 } },
    { /* 56 */ 0, { 57, 58 } },
    { /* 57 */ 0, { 58, 59 } },
    { /* 58 */ 0, { 59, 60 } },
    { /* 59 */ 1, {  6,  0 } },
    { /* 60 */ 1, {  5,  4 } },
    { /* 61 */ 1, {  6,  3 } },
    { /* 62 */ 1, {  8,  3 } },
    { /* 63 */ 1, {  0,  7 } },
    { /* 64 */ 1, {  9,  2 } },
    { /* 65 */ 1, {  3,  8 } },
    { /* 66 */ 1, {  4,  6 } },
    { /* 67 */ 1, {  3,  7 } },
    { /* 68 */ 1, {  0,  8 } },
    { /* 69 */ 1, { 10,  1 } },
    { /* 70 */ 1, {  6,  4 } },
    { /* 71 */ 1, {  2,  9 } },
    { /* 72 */ 1, {  5,  5 } },
    { /* 73 */ 1, {  8,  0 } },
    { /* 74 */ 1, {  7,  0 } },
    { /* 75 */ 1, {  7,  3 } },
    { /* 76 */ 1, { 10,  2 } },
    { /* 77 */ 1, {  9,  3 } },
    { /* 78 */ 1, {  8,  4 } },
    { /* 79 */ 1, {  1, 10 } },
    { /* 80 */ 1, {  7,  4 } },
    { /* 81 */ 1, {  6,  5 } },
    { /* 82 */ 1, {  5,  6 } },
    { /* 83 */ 1, {  4,  8 } },
    { /* 84 */ 1, {  4,  7 } },
    { /* 85 */ 1, {  3,  9 } },
    { /* 86 */ 1, { 11,  1 } },
    { /* 87 */ 1, {  5,  8 } },
    { /* 88 */ 1, {  9,  0 } },
    { /* 89 */ 1, {  8,  5 } },
    { /* 90 */ 0, { 29, 30 } },
    { /* 91 */ 0, { 30, 31 } },
    { /* 92 */ 0, { 31, 32 } },
    { /* 93 */ 0, { 32, 33 } },
    { /* 94 */ 0, { 33, 34 } },
    { /* 95 */ 0, { 34, 35 } },
    { /* 96 */ 0, { 35, 36 } },
    { /* 97 */ 0, { 36, 37 } },
    { /* 98 */ 0, { 37, 38 } },
    { /* 99 */ 0, { 38, 39 } },
    { /* 00 */ 0, { 39, 40 } },
    { /* 01 */ 0, { 40, 41 } },
    { /* 02 */ 0, { 41, 42 } },
    { /* 03 */ 0, { 42, 43 } },
    { /* 04 */ 0, { 43, 44 } },
    { /* 05 */ 0, { 44, 45 } },
    { /* 06 */ 0, { 45, 46 } },
    { /* 07 */ 0, { 46, 47 } },
    { /* 08 */ 0, { 47, 48 } },
    { /* 09 */ 0, { 48, 49 } },
    { /* 10 */ 0, { 49, 50 } },
    { /* 11 */ 0, { 50, 51 } },
    { /* 12 */ 0, { 51, 52 } },
    { /* 13 */ 0, { 52, 53 } },
    { /* 14 */ 0, { 53, 54 } },
    { /* 15 */ 0, { 54, 55 } },
    { /* 16 */ 0, { 55, 56 } },
    { /* 17 */ 0, { 56, 57 } },
    { /* 18 */ 0, { 57, 58 } },
    { /* 19 */ 1, { 10,  3 } },
    { /* 20 */ 1, {  2, 10 } },
    { /* 21 */ 1, {  0,  9 } },
    { /* 22 */ 1, { 11,  2 } },
    { /* 23 */ 1, {  9,  4 } },
    { /* 24 */ 1, {  6,  6 } },
    { /* 25 */ 1, { 12,  1 } },
    { /* 26 */ 1, {  4,  9 } },
    { /* 27 */ 1, {  8,  6 } },
    { /* 28 */ 1, {  1, 11 } },
    { /* 29 */ 1, {  9,  5 } },
    { /* 30 */ 1, { 10,  4 } },
    { /* 31 */ 1, {  5,  7 } },
    { /* 32 */ 1, {  7,  5 } },
    { /* 33 */ 1, {  2, 11 } },
    { /* 34 */ 1, {  1, 12 } },
    { /* 35 */ 1, { 12,  2 } },
    { /* 36 */ 1, { 11,  3 } },
    { /* 37 */ 1, {  3, 10 } },
    { /* 38 */ 1, {  5,  9 } },
    { /* 39 */ 1, {  6,  7 } },
    { /* 40 */ 1, {  8,  7 } },
    { /* 41 */ 1, { 11,  4 } },
    { /* 42 */ 1, {  0, 10 } },
    { /* 43 */ 1, {  7,  6 } },
    { /* 44 */ 1, { 12,  3 } },
    { /* 45 */ 1, { 10,  0 } },
    { /* 46 */ 1, { 10,  5 } },
    { /* 47 */ 1, {  4, 10 } },
    { /* 48 */ 1, {  6,  8 } },
    { /* 49 */ 1, {  2, 12 } },
    { /* 50 */ 1, {  9,  6 } },
    { /* 51 */ 1, {  9,  7 } },
    { /* 52 */ 1, {  4, 11 } },
    { /* 53 */ 1, { 11,  0 } },
    { /* 54 */ 1, {  6,  9 } },
    { /* 55 */ 1, {  3, 11 } },
    { /* 56 */ 1, {  5, 10 } },
    { /* 57 */ 0, { 20, 21 } },
    { /* 58 */ 0, { 21, 22 } },
    { /* 59 */ 0, { 22, 23 } },
    { /* 60 */ 0, { 23, 24 } },
    { /* 61 */ 0, { 24, 25 } },
    { /* 62 */ 0, { 25, 26 } },
    { /* 63 */ 0, { 26, 27 } },
    { /* 64 */ 0, { 27, 28 } },
    { /* 65 */ 0, { 28, 29 } },
    { /* 66 */ 0, { 29, 30 } },
    { /* 67 */ 0, { 30, 31 } },
    { /* 68 */ 0, { 31, 32 } },
    { /* 69 */ 0, { 32, 33 } },
    { /* 70 */ 0, { 33, 34 } },
    { /* 71 */ 0, { 34, 35 } },
    { /* 72 */ 0, { 35, 36 } },
    { /* 73 */ 0, { 36, 37 } },
    { /* 74 */ 0, { 37, 38 } },
    { /* 75 */ 0, { 38, 39 } },
    { /* 76 */ 0, { 39, 40 } },
    { /* 77 */ 1, {  8,  8 } },
    { /* 78 */ 1, {  7,  8 } },
    { /* 79 */ 1, { 12,  5 } },
    { /* 80 */ 1, {  3, 12 } },
    { /* 81 */ 1, { 11,  5 } },
    { /* 82 */ 1, {  7,  7 } },
    { /* 83 */ 1, { 12,  4 } },
    { /* 84 */ 1, { 11,  6 } },
    { /* 85 */ 1, { 10,  6 } },
    { /* 86 */ 1, {  4, 12 } },
    { /* 87 */ 1, {  7,  9 } },
    { /* 88 */ 1, {  5, 11 } },
    { /* 89 */ 1, {  0, 11 } },
    { /* 90 */ 1, { 12,  6 } },
    { /* 91 */ 1, {  6, 10 } },
    { /* 92 */ 1, { 12,  0 } },
    { /* 93 */ 1, { 10,  7 } },
    { /* 94 */ 1, {  5, 12 } },
    { /* 95 */ 1, {  7, 10 } },
    { /* 96 */ 1, {  9,  8 } },
    { /* 97 */ 1, {  0, 12 } },
    { /* 98 */ 1, { 11,  7 } },
    { /* 99 */ 1, {  8,  9 } },
    { /* 00 */ 1, {  9,  9 } },
    { /* 01 */ 1, { 10,  8 } },
    { /* 02 */ 1, {  7, 11 } },
    { /* 03 */ 1, { 12,  7 } },
    { /* 04 */ 1, {  6, 11 } },
    { /* 05 */ 1, {  8, 11 } },
    { /* 06 */ 1, { 11,  8 } },
    { /* 07 */ 1, {  7, 12 } },
    { /* 08 */ 1, {  6, 12 } },
    { /* 09 */ 0, { 8, 9 } },
    { /* 10 */ 0, { 9, 10 } },
    { /* 11 */ 0, { 10, 11 } },
    { /* 12 */ 0, { 11, 12 } },
    { /* 13 */ 0, { 12, 13 } },
    { /* 14 */ 0, { 13, 14 } },
    { /* 15 */ 0, { 14, 15 } },
    { /* 16 */ 0, { 15, 16 } },
    { /* 17 */ 1, {  8, 10 } },
    { /* 18 */ 1, { 10,  9 } },
    { /* 19 */ 1, {  8, 12 } },
    { /* 20 */ 1, {  9, 10 } },
    { /* 21 */ 1, {  9, 11 } },
    { /* 22 */ 1, {  9, 12 } },
    { /* 23 */ 1, { 10, 11 } },
    { /* 24 */ 1, { 12,  9 } },
    { /* 25 */ 1, { 10, 10 } },
    { /* 26 */ 1, { 11,  9 } },
    { /* 27 */ 1, { 12,  8 } },
    { /* 28 */ 1, { 11, 10 } },
    { /* 29 */ 1, { 12, 10 } },
    { /* 30 */ 1, { 12, 11 } },
    { /* 31 */ 0, { 2, 3 } },
    { /* 32 */ 0, { 3, 4 } },
    { /* 33 */ 1, { 10, 12 } },
    { /* 34 */ 1, { 11, 11 } },
    { /* 35 */ 1, { 11, 12 } },
    { /* 36 */ 1, { 12, 12 } }
};

const AacHcb aacHcb10Step1[] = {
    // 4 bit codewords
    { /* 000000 */ 0, 0 },
    { /*        */ 0, 0 },
    { /*        */ 0, 0 },
    { /*        */ 0, 0 },
    { /* 000100 */ 1, 0 },
    { /*        */ 1, 0 },
    { /*        */ 1, 0 },
    { /*        */ 1, 0 },
    { /* 001000 */ 2, 0 },
    { /*        */ 2, 0 },
    { /*        */ 2, 0 },
    { /*        */ 2, 0 },
    // 5 bit codewords
    { /* 001100 */ 3, 0 },
    { /*        */ 3, 0 },
    { /* 001110 */ 4, 0 },
    { /*        */ 4, 0 },
    { /* 010000 */ 5, 0 },
    { /*        */ 5, 0 },
    { /* 010010 */ 6, 0 },
    { /*        */ 6, 0 },
    { /* 010100 */ 7, 0 },
    { /*        */ 7, 0 },
    { /* 010110 */ 8, 0 },
    { /*        */ 8, 0 },
    { /* 011000 */ 9, 0 },
    { /*        */ 9, 0 },
    { /* 011010 */ 10, 0 },
    { /*        */ 10, 0 },
    // 6 bit codewords
    { /* 011100 */ 11, 0 },
    { /* 011101 */ 12, 0 },
    { /* 011110 */ 13, 0 },
    { /* 011111 */ 14, 0 },
    { /* 100000 */ 15, 0 },
    { /* 100001 */ 16, 0 },
    { /* 100010 */ 17, 0 },
    { /* 100011 */ 18, 0 },
    { /* 100100 */ 19, 0 },
    { /* 100101 */ 20, 0 },
    { /* 100110 */ 21, 0 },
    { /* 100111 */ 22, 0 },
    { /* 101000 */ 23, 0 },
    { /* 101001 */ 24, 0 },
    // 7 bit codewords
    { /* 101010 */ 25, 1 },
    { /* 101011 */ 27, 1 },
    { /* 101100 */ 29, 1 },
    { /* 101101 */ 31, 1 },
    { /* 101110 */ 33, 1 },
    { /* 101111 */ 35, 1 },
    { /* 110000 */ 37, 1 },
    { /* 110001 */ 39, 1 },
    // 7/8 bit codewords
    { /* 110010 */ 41, 2 },
    // 8 bit codewords
    { /* 110011 */ 45, 2 },
    { /* 110100 */ 49, 2 },
    { /* 110101 */ 53, 2 },
    { /* 110110 */ 57, 2 },
    { /* 110111 */ 61, 2 },
    // 8/9 bit codewords
    { /* 111000 */ 65, 3 },
    // 9 bit codewords
    { /* 111001 */ 73, 3 },
    { /* 111010 */ 81, 3 },
    { /* 111011 */ 89, 3 },
    // 9/10 bit codewords
    { /* 111100 */ 97, 4 },
    // 10 bit codewords
    { /* 111101 */ 113, 4 },
    { /* 111110 */ 129, 4 },
    // 10/11/12 bit codewords
    { /* 111111 */ 145, 6 }
};

const AacHcb2Pair aacHcb10Step2[] = {
    // 4 bit codewords
    { 4,  1,  1 },
    { 4,  1,  2 },
    { 4,  2,  1 },

    // 5 bit codewords
    { 5,  2,  2 },
    { 5,  1,  0 },
    { 5,  0,  1 },
    { 5,  1,  3 },
    { 5,  3,  2 },
    { 5,  3,  1 },
    { 5,  2,  3 },
    { 5,  3,  3 },

    // 6 bit codewords
    { 6,  2,  0 },
    { 6,  0,  2 },
    { 6,  2,  4 },
    { 6,  4,  2 },
    { 6,  1,  4 },
    { 6,  4,  1 },
    { 6,  0,  0 },
    { 6,  4,  3 },
    { 6,  3,  4 },
    { 6,  3,  0 },
    { 6,  0,  3 },
    { 6,  4,  4 },
    { 6,  2,  5 },
    { 6,  5,  2 },

    // 7 bit codewords
    { 7,  1,  5 },
    { 7,  5,  1 },
    { 7,  5,  3 },
    { 7,  3,  5 },
    { 7,  5,  4 },
    { 7,  4,  5 },
    { 7,  6,  2 },
    { 7,  2,  6 },
    { 7,  6,  3 },
    { 7,  4,  0 },
    { 7,  6,  1 },
    { 7,  0,  4 },
    { 7,  1,  6 },
    { 7,  3,  6 },
    { 7,  5,  5 },
    { 7,  6,  4 },

    // 7/8 bit codewords
    { 7,  4,  6 }, { 7,  4,  6 },
    { 8,  6,  5 },
    { 8,  7,  2 },

    // 8 bit codewords
    { 8,  3,  7 },
    { 8,  2,  7 },
    { 8,  5,  6 },
    { 8,  8,  2 },
    { 8,  7,  3 },
    { 8,  5,  0 },
    { 8,  7,  1 },
    { 8,  0,  5 },
    { 8,  8,  1 },
    { 8,  1,  7 },
    { 8,  8,  3 },
    { 8,  7,  4 },
    { 8,  4,  7 },
    { 8,  2,  8 },
    { 8,  6,  6 },
    { 8,  7,  5 },
    { 8,  1,  8 },
    { 8,  3,  8 },
    { 8,  8,  4 },
    { 8,  4,  8 },

    // 8/9 bit codewords
    { 8,  5,  7 }, { 8,  5,  7 },
    { 8,  8,  5 }, { 8,  8,  5 },
    { 8,  5,  8 }, { 8,  5,  8 },
    { 9,  7,  6 },
    { 9,  6,  7 },

    // 9 bit codewords
    { 9,  9,  2 },
    { 9,  6,  0 },
    { 9,  6,  8 },
    { 9,  9,  3 },
    { 9,  3,  9 },
    { 9,  9,  1 },
    { 9,  2,  9 },
    { 9,  0,  6 },
    { 9,  8,  6 },
    { 9,  9,  4 },
    { 9,  4,  9 },
    { 9, 10,  2 },
    { 9,  1,  9 },
    { 9,  7,  7 },
    { 9,  8,  7 },
    { 9,  9,  5 },
    { 9,  7,  8 },
    { 9, 10,  3 },
    { 9,  5,  9 },
    { 9, 10,  4 },
    { 9,  2, 10 },
    { 9, 10,  1 },
    { 9,  3, 10 },
    { 9,  9,  6 },

    // 9/10 bit codewords
    { 9,  6,  9 }, { 9,  6,  9 },
    { 9,  8,  0 }, { 9,  8,  0 },
    { 9,  4, 10 }, { 9,  4, 10 },
    { 9,  7,  0 }, { 9,  7,  0 },
    { 9, 11,  2 }, { 9, 11,  2 },
    { 10,  7,  9 },
    { 10, 11,  3 },
    { 10, 10,  6 },
    { 10,  1, 10 },
    { 10, 11,  1 },
    { 10,  9,  7 },

    // 10 bit codewords
    { 10,  0,  7 },
    { 10,  8,  8 },
    { 10, 10,  5 },
    { 10,  3, 11 },
    { 10,  5, 10 },
    { 10,  8,  9 },
    { 10, 11,  5 },
    { 10,  0,  8 },
    { 10, 11,  4 },
    { 10,  2, 11 },
    { 10,  7, 10 },
    { 10,  6, 10 },
    { 10, 10,  7 },
    { 10,  4, 11 },
    { 10,  1, 11 },
    { 10, 12,  2 },
    { 10,  9,  8 },
    { 10, 12,  3 },
    { 10, 11,  6 },
    { 10,  5, 11 },
    { 10, 12,  4 },
    { 10, 11,  7 },
    { 10, 12,  5 },
    { 10,  3, 12 },
    { 10,  6, 11 },
    { 10,  9,  0 },
    { 10, 10,  8 },
    { 10, 10,  0 },
    { 10, 12,  1 },
    { 10,  0,  9 },
    { 10,  4, 12 },
    { 10,  9,  9 },

    // 10/11/12 bit codewords
    { 10, 12,  6 }, { 10, 12,  6 }, { 10, 12,  6 }, { 10, 12,  6 },
    { 10,  2, 12 }, { 10,  2, 12 }, { 10,  2, 12 }, { 10,  2, 12 },
    { 10,  8, 10 }, { 10,  8, 10 }, { 10,  8, 10 }, { 10,  8, 10 },
    { 11,  9, 10 }, { 11,  9, 10 },
    { 11,  1, 12 }, { 11,  1, 12 },
    { 11, 11,  8 }, { 11, 11,  8 },
    { 11, 12,  7 }, { 11, 12,  7 },
    { 11,  7, 11 }, { 11,  7, 11 },
    { 11,  5, 12 }, { 11,  5, 12 },
    { 11,  6, 12 }, { 11,  6, 12 },
    { 11, 10,  9 }, { 11, 10,  9 },
    { 11,  8, 11 }, { 11,  8, 11 },
    { 11, 12,  8 }, { 11, 12,  8 },
    { 11,  0, 10 }, { 11,  0, 10 },
    { 11,  7, 12 }, { 11,  7, 12 },
    { 11, 11,  0 }, { 11, 11,  0 },
    { 11, 10, 10 }, { 11, 10, 10 },
    { 11, 11,  9 }, { 11, 11,  9 },
    { 11, 11, 10 }, { 11, 11, 10 },
    { 11,  0, 11 }, { 11,  0, 11 },
    { 11, 11, 11 }, { 11, 11, 11 },
    { 11,  9, 11 }, { 11,  9, 11 },
    { 11, 10, 11 }, { 11, 10, 11 },
    { 11, 12,  0 }, { 11, 12,  0 },
    { 11,  8, 12 }, { 11,  8, 12 },
    { 12, 12,  9 },
    { 12, 10, 12 },
    { 12,  9, 12 },
    { 12, 11, 12 },
    { 12, 12, 11 },
    { 12,  0, 12 },
    { 12, 12, 10 },
    { 12, 12, 12 }
};

const AacHcb aacHcb11Step1[] = {
    // 4 bits
    { /* 00000 */ 0, 0 },
    { /*       */ 0, 0 },
    { /* 00010 */ 1, 0 },
    { /*       */ 1, 0 },

    // 5 bits
    { /* 00100 */ 2, 0 },
    { /* 00101 */ 3, 0 },
    { /* 00110 */ 4, 0 },
    { /* 00111 */ 5, 0 },
    { /* 01000 */ 6, 0 },
    { /* 01001 */ 7, 0 },

    // 6 bits
    { /* 01010 */ 8,  1 },
    { /* 01011 */ 10, 1 },
    { /* 01100 */ 12, 1 },

    // 6/7 bits
    { /* 01101 */ 14, 2 },

    // 7 bits
    { /* 01110 */ 18, 2 },
    { /* 01111 */ 22, 2 },
    { /* 10000 */ 26, 2 },

    // 7/8 bits
    { /* 10001 */ 30, 3 },

    // 8 bits
    { /* 10010 */ 38, 3 },
    { /* 10011 */ 46, 3 },
    { /* 10100 */ 54, 3 },
    { /* 10101 */ 62, 3 },
    { /* 10110 */ 70, 3 },
    { /* 10111 */ 78, 3 },

    // 8/9 bits
    { /* 11000 */ 86, 4 },

    // 9 bits
    { /* 11001 */ 102, 4 },
    { /* 11010 */ 118, 4 },
    { /* 11011 */ 134, 4 },

    // 9/10 bits
    { /* 11100 */ 150, 5 },

    // 10 bits
    { /* 11101 */ 182, 5 },
    { /* 11110 */ 214, 5 },

    // 10/11/12 bits
    { /* 11111 */ 246, 7 }
};

const AacHcb2Pair aacHcb11Step2[] = {
    // 4
    { 4,  0,  0 },
    { 4,  1,  1 },

    // 5
    { 5, 16, 16 },
    { 5,  1,  0 },
    { 5,  0,  1 },
    { 5,  2,  1 },
    { 5,  1,  2 },
    { 5,  2,  2 },

    // 6
    { 6,  1,  3 },
    { 6,  3,  1 },
    { 6,  3,  2 },
    { 6,  2,  0 },
    { 6,  2,  3 },
    { 6,  0,  2 },

    // 6/7
    { 6,  3,  3 }, { 6,  3,  3 },
    { 7,  4,  1 },
    { 7,  1,  4 },

    // 7
    { 7,  4,  2 },
    { 7,  2,  4 },
    { 7,  4,  3 },
    { 7,  3,  4 },
    { 7,  3,  0 },
    { 7,  0,  3 },
    { 7,  5,  1 },
    { 7,  5,  2 },
    { 7,  2,  5 },
    { 7,  4,  4 },
    { 7,  1,  5 },
    { 7,  5,  3 },

    // 7/8
    { 7,  3,  5 }, { 7,  3,  5 },
    { 7,  5,  4 }, { 7,  5,  4 },
    { 8,  4,  5 },
    { 8,  6,  2 },
    { 8,  2,  6 },
    { 8,  6,  1 },

    // 8
    { 8,  6,  3 },
    { 8,  3,  6 },
    { 8,  1,  6 },
    { 8,  4, 16 },
    { 8,  3, 16 },
    { 8, 16,  5 },
    { 8, 16,  3 },
    { 8, 16,  4 },
    { 8,  6,  4 },
    { 8, 16,  6 },
    { 8,  4,  0 },
    { 8,  4,  6 },
    { 8,  0,  4 },
    { 8,  2, 16 },
    { 8,  5,  5 },
    { 8,  5, 16 },
    { 8, 16,  7 },
    { 8, 16,  2 },
    { 8, 16,  8 },
    { 8,  2,  7 },
    { 8,  7,  2 },
    { 8,  3,  7 },
    { 8,  6,  5 },
    { 8,  5,  6 },
    { 8,  6, 16 },
    { 8, 16, 10 },
    { 8,  7,  3 },
    { 8,  7,  1 },
    { 8, 16,  9 },
    { 8,  7, 16 },
    { 8,  1, 16 },
    { 8,  1,  7 },
    { 8,  4,  7 },
    { 8, 16, 11 },
    { 8,  7,  4 },
    { 8, 16, 12 },
    { 8,  8, 16 },
    { 8, 16,  1 },
    { 8,  6,  6 },
    { 8,  9, 16 },
    { 8,  2,  8 },
    { 8,  5,  7 },
    { 8, 10, 16 },
    { 8, 16, 13 },
    { 8,  8,  3 },
    { 8,  8,  2 },
    { 8,  3,  8 },
    { 8,  5,  0 },

    // 8/9
    { 8, 16, 14 }, { 8, 16, 14 },
    { 8, 11, 16 }, { 8, 11, 16 },
    { 8,  7,  5 }, { 8,  7,  5 },
    { 8,  4,  8 }, { 8,  4,  8 },
    { 8,  6,  7 }, { 8,  6,  7 },
    { 8,  7,  6 }, { 8,  7,  6 },
    { 8,  0,  5 }, { 8,  0,  5 },
    { 9,  8,  4 },
    { 9, 16, 15 },

    // 9
    { 9, 12, 16 },
    { 9,  1,  8 },
    { 9,  8,  1 },
    { 9, 14, 16 },
    { 9,  5,  8 },
    { 9, 13, 16 },
    { 9,  3,  9 },
    { 9,  8,  5 },
    { 9,  7,  7 },
    { 9,  2,  9 },
    { 9,  8,  6 },
    { 9,  9,  2 },
    { 9,  9,  3 },
    { 9, 15, 16 },
    { 9,  4,  9 },
    { 9,  6,  8 },
    { 9,  6,  0 },
    { 9,  9,  4 },
    { 9,  5,  9 },
    { 9,  8,  7 },
    { 9,  7,  8 },
    { 9,  1,  9 },
    { 9, 10,  3 },
    { 9,  0,  6 },
    { 9, 10,  2 },
    { 9,  9,  1 },
    { 9,  9,  5 },
    { 9,  4, 10 },
    { 9,  2, 10 },
    { 9,  9,  6 },
    { 9,  3, 10 },
    { 9,  6,  9 },
    { 9, 10,  4 },
    { 9,  8,  8 },
    { 9, 10,  5 },
    { 9,  9,  7 },
    { 9, 11,  3 },
    { 9,  1, 10 },
    { 9,  7,  0 },
    { 9, 10,  6 },
    { 9,  7,  9 },
    { 9,  3, 11 },
    { 9,  5, 10 },
    { 9, 10,  1 },
    { 9,  4, 11 },
    { 9, 11,  2 },
    { 9, 13,  2 },
    { 9,  6, 10 },

    // 9/10
    { 9, 13,  3 }, { 9, 13,  3 },
    { 9,  2, 11 }, { 9,  2, 11 },
    { 9, 16,  0 }, { 9, 16,  0 },
    { 9,  5, 11 }, { 9,  5, 11 },
    { 9, 11,  5 }, { 9, 11,  5 },
    { 10, 11,  4 },
    { 10,  9,  8 },
    { 10,  7, 10 },
    { 10,  8,  9 },
    { 10,  0, 16 },
    { 10,  4, 13 },
    { 10,  0,  7 },
    { 10,  3, 13 },
    { 10, 11,  6 },
    { 10, 13,  1 },
    { 10, 13,  4 },
    { 10, 12,  3 },
    { 10,  2, 13 },
    { 10, 13,  5 },
    { 10,  8, 10 },
    { 10,  6, 11 },
    { 10, 10,  8 },
    { 10, 10,  7 },
    { 10, 14,  2 },
    { 10, 12,  4 },
    { 10,  1, 11 },
    { 10,  4, 12 },

    // 10
    { 10, 11,  1 },
    { 10,  3, 12 },
    { 10,  1, 13 },
    { 10, 12,  2 },
    { 10,  7, 11 },
    { 10,  3, 14 },
    { 10,  5, 12 },
    { 10,  5, 13 },
    { 10, 14,  4 },
    { 10,  4, 14 },
    { 10, 11,  7 },
    { 10, 14,  3 },
    { 10, 12,  5 },
    { 10, 13,  6 },
    { 10, 12,  6 },
    { 10,  8,  0 },
    { 10, 11,  8 },
    { 10,  2, 12 },
    { 10,  9,  9 },
    { 10, 14,  5 },
    { 10,  6, 13 },
    { 10, 10, 10 },
    { 10, 15,  2 },
    { 10,  8, 11 },
    { 10,  9, 10 },
    { 10, 14,  6 },
    { 10, 10,  9 },
    { 10,  5, 14 },
    { 10, 11,  9 },
    { 10, 14,  1 },
    { 10,  2, 14 },
    { 10,  6, 12 },
    { 10,  1, 12 },
    { 10, 13,  8 },
    { 10,  0,  8 },
    { 10, 13,  7 },
    { 10,  7, 12 },
    { 10, 12,  7 },
    { 10,  7, 13 },
    { 10, 15,  3 },
    { 10, 12,  1 },
    { 10,  6, 14 },
    { 10,  2, 15 },
    { 10, 15,  5 },
    { 10, 15,  4 },
    { 10,  1, 14 },
    { 10,  9, 11 },
    { 10,  4, 15 },
    { 10, 14,  7 },
    { 10,  8, 13 },
    { 10, 13,  9 },
    { 10,  8, 12 },
    { 10,  5, 15 },
    { 10,  3, 15 },
    { 10, 10, 11 },
    { 10, 11, 10 },
    { 10, 12,  8 },
    { 10, 15,  6 },
    { 10, 15,  7 },
    { 10,  8, 14 },
    { 10, 15,  1 },
    { 10,  7, 14 },
    { 10,  9,  0 },
    { 10,  0,  9 },

    // 10/11/12
    { 10,  9, 13 }, { 10,  9, 13 }, { 10,  9, 13 }, { 10,  9, 13 },
    { 10,  9, 12 }, { 10,  9, 12 }, { 10,  9, 12 }, { 10,  9, 12 },
    { 10, 12,  9 }, { 10, 12,  9 }, { 10, 12,  9 }, { 10, 12,  9 },
    { 10, 14,  8 }, { 10, 14,  8 }, { 10, 14,  8 }, { 10, 14,  8 },
    { 10, 10, 13 }, { 10, 10, 13 }, { 10, 10, 13 }, { 10, 10, 13 },
    { 10, 14,  9 }, { 10, 14,  9 }, { 10, 14,  9 }, { 10, 14,  9 },
    { 10, 12, 10 }, { 10, 12, 10 }, { 10, 12, 10 }, { 10, 12, 10 },
    { 10,  6, 15 }, { 10,  6, 15 }, { 10,  6, 15 }, { 10,  6, 15 },
    { 10,  7, 15 }, { 10,  7, 15 }, { 10,  7, 15 }, { 10,  7, 15 },

    { 11,  9, 14 }, { 11,  9, 14 },
    { 11, 15,  8 }, { 11, 15,  8 },
    { 11, 11, 11 }, { 11, 11, 11 },
    { 11, 11, 14 }, { 11, 11, 14 },
    { 11,  1, 15 }, { 11,  1, 15 },
    { 11, 10, 12 }, { 11, 10, 12 },
    { 11, 10, 14 }, { 11, 10, 14 },
    { 11, 13, 11 }, { 11, 13, 11 },
    { 11, 13, 10 }, { 11, 13, 10 },
    { 11, 11, 13 }, { 11, 11, 13 },
    { 11, 11, 12 }, { 11, 11, 12 },
    { 11,  8, 15 }, { 11,  8, 15 },
    { 11, 14, 11 }, { 11, 14, 11 },
    { 11, 13, 12 }, { 11, 13, 12 },
    { 11, 12, 13 }, { 11, 12, 13 },
    { 11, 15,  9 }, { 11, 15,  9 },
    { 11, 14, 10 }, { 11, 14, 10 },
    { 11, 10,  0 }, { 11, 10,  0 },
    { 11, 12, 11 }, { 11, 12, 11 },
    { 11,  9, 15 }, { 11,  9, 15 },
    { 11,  0, 10 }, { 11,  0, 10 },
    { 11, 12, 12 }, { 11, 12, 12 },
    { 11, 11,  0 }, { 11, 11,  0 },
    { 11, 12, 14 }, { 11, 12, 14 },
    { 11, 10, 15 }, { 11, 10, 15 },
    { 11, 13, 13 }, { 11, 13, 13 },
    { 11,  0, 13 }, { 11,  0, 13 },
    { 11, 14, 12 }, { 11, 14, 12 },
    { 11, 15, 10 }, { 11, 15, 10 },
    { 11, 15, 11 }, { 11, 15, 11 },
    { 11, 11, 15 }, { 11, 11, 15 },
    { 11, 14, 13 }, { 11, 14, 13 },
    { 11, 13,  0 }, { 11, 13,  0 },
    { 11,  0, 11 }, { 11,  0, 11 },
    { 11, 13, 14 }, { 11, 13, 14 },
    { 11, 15, 12 }, { 11, 15, 12 },
    { 11, 15, 13 }, { 11, 15, 13 },
    { 11, 12, 15 }, { 11, 12, 15 },
    { 11, 14,  0 }, { 11, 14,  0 },
    { 11, 14, 14 }, { 11, 14, 14 },
    { 11, 13, 15 }, { 11, 13, 15 },
    { 11, 12,  0 }, { 11, 12,  0 },
    { 11, 14, 15 }, { 11, 14, 15 },
    { 12,  0, 14 },
    { 12,  0, 12 },
    { 12, 15, 14 },
    { 12, 15,  0 },
    { 12,  0, 15 },
    { 12, 15, 15 }
};

const std::uint8_t aacHcbSf[][2] = {
    { /*  0 */  1, 2 },
    { /*  1 */  60, 0 },
    { /*  2 */  1, 2 },
    { /*  3 */  2, 3 },
    { /*  4 */  3, 4 },
    { /*  5 */  59, 0 },
    { /*  6 */  3, 4 },
    { /*  7 */  4, 5 },
    { /*  8 */  5, 6 },
    { /*  9 */  61, 0 },
    { /* 10 */  58, 0 },
    { /* 11 */  62, 0 },
    { /* 12 */  3, 4 },
    { /* 13 */  4, 5 },
    { /* 14 */  5, 6 },
    { /* 15 */  57, 0 },
    { /* 16 */  63, 0 },
    { /* 17 */  4, 5 },
    { /* 18 */  5, 6 },
    { /* 19 */  6, 7 },
    { /* 20 */  7, 8 },
    { /* 21 */  56, 0 },
    { /* 22 */  64, 0 },
    { /* 23 */  55, 0 },
    { /* 24 */  65, 0 },
    { /* 25 */  4, 5 },
    { /* 26 */  5, 6 },
    { /* 27 */  6, 7 },
    { /* 28 */  7, 8 },
    { /* 29 */  66, 0 },
    { /* 30 */  54, 0 },
    { /* 31 */  67, 0 },
    { /* 32 */  5, 6 },
    { /* 33 */  6, 7 },
    { /* 34 */  7, 8 },
    { /* 35 */  8, 9 },
    { /* 36 */  9, 10 },
    { /* 37 */  53, 0 },
    { /* 38 */  68, 0 },
    { /* 39 */  52, 0 },
    { /* 40 */  69, 0 },
    { /* 41 */  51, 0 },
    { /* 42 */  5, 6 },
    { /* 43 */  6, 7 },
    { /* 44 */  7, 8 },
    { /* 45 */  8, 9 },
    { /* 46 */  9, 10 },
    { /* 47 */  70, 0 },
    { /* 48 */  50, 0 },
    { /* 49 */  49, 0 },
    { /* 50 */  71, 0 },
    { /* 51 */  6, 7 },
    { /* 52 */  7, 8 },
    { /* 53 */  8, 9 },
    { /* 54 */  9, 10 },
    { /* 55 */  10, 11 },
    { /* 56 */  11, 12 },
    { /* 57 */  72, 0 },
    { /* 58 */  48, 0 },
    { /* 59 */  73, 0 },
    { /* 60 */  47, 0 },
    { /* 61 */  74, 0 },
    { /* 62 */  46, 0 },
    { /* 63 */  6, 7 },
    { /* 64 */  7, 8 },
    { /* 65 */  8, 9 },
    { /* 66 */  9, 10 },
    { /* 67 */  10, 11 },
    { /* 68 */  11, 12 },
    { /* 69 */  76, 0 },
    { /* 70 */  75, 0 },
    { /* 71 */  77, 0 },
    { /* 72 */  78, 0 },
    { /* 73 */  45, 0 },
    { /* 74 */  43, 0 },
    { /* 75 */  6, 7 },
    { /* 76 */  7, 8 },
    { /* 77 */  8, 9 },
    { /* 78 */  9, 10 },
    { /* 79 */  10, 11 },
    { /* 80 */  11, 12 },
    { /* 81 */  44, 0 },
    { /* 82 */  79, 0 },
    { /* 83 */  42, 0 },
    { /* 84 */  41, 0 },
    { /* 85 */  80, 0 },
    { /* 86 */  40, 0 },
    { /* 87 */  6, 7 },
    { /* 88 */  7, 8 },
    { /* 89 */  8, 9 },
    { /* 90 */  9, 10 },
    { /* 91 */  10, 11 },
    { /* 92 */  11, 12 },
    { /* 93 */  81, 0 },
    { /* 94 */  39, 0 },
    { /* 95 */  82, 0 },
    { /* 96 */  38, 0 },
    { /* 97 */  83, 0 },
    { /* 98 */  7, 8 },
    { /* 99 */  8, 9 },
    { /* 00 */  9, 10 },
    { /* 01 */  10, 11 },
    { /* 02 */  11, 12 },
    { /* 03 */  12, 13 },
    { /* 04 */  13, 14 },
    { /* 05 */  37, 0 },
    { /* 06 */  35, 0 },
    { /* 07 */  85, 0 },
    { /* 08 */  33, 0 },
    { /* 09 */  36, 0 },
    { /* 10 */  34, 0 },
    { /* 11 */  84, 0 },
    { /* 12 */  32, 0 },
    { /* 13 */  6, 7 },
    { /* 14 */  7, 8 },
    { /* 15 */  8, 9 },
    { /* 16 */  9, 10 },
    { /* 17 */  10, 11 },
    { /* 18 */  11, 12 },
    { /* 19 */  87, 0 },
    { /* 20 */  89, 0 },
    { /* 21 */  30, 0 },
    { /* 22 */  31, 0 },
    { /* 23 */  8, 9 },
    { /* 24 */  9, 10 },
    { /* 25 */  10, 11 },
    { /* 26 */  11, 12 },
    { /* 27 */  12, 13 },
    { /* 28 */  13, 14 },
    { /* 29 */  14, 15 },
    { /* 30 */  15, 16 },
    { /* 31 */  86, 0 },
    { /* 32 */  29, 0 },
    { /* 33 */  26, 0 },
    { /* 34 */  27, 0 },
    { /* 35 */  28, 0 },
    { /* 36 */  24, 0 },
    { /* 37 */  88, 0 },
    { /* 38 */  9, 10 },
    { /* 39 */  10, 11 },
    { /* 40 */  11, 12 },
    { /* 41 */  12, 13 },
    { /* 42 */  13, 14 },
    { /* 43 */  14, 15 },
    { /* 44 */  15, 16 },
    { /* 45 */  16, 17 },
    { /* 46 */  17, 18 },
    { /* 47 */  25, 0 },
    { /* 48 */  22, 0 },
    { /* 49 */  23, 0 },
    { /* 50 */  15, 16 },
    { /* 51 */  16, 17 },
    { /* 52 */  17, 18 },
    { /* 53 */  18, 19 },
    { /* 54 */  19, 20 },
    { /* 55 */  20, 21 },
    { /* 56 */  21, 22 },
    { /* 57 */  22, 23 },
    { /* 58 */  23, 24 },
    { /* 59 */  24, 25 },
    { /* 60 */  25, 26 },
    { /* 61 */  26, 27 },
    { /* 62 */  27, 28 },
    { /* 63 */  28, 29 },
    { /* 64 */  29, 30 },
    { /* 65 */  90, 0 },
    { /* 66 */  21, 0 },
    { /* 67 */  19, 0 },
    { /* 68 */   3, 0 },
    { /* 69 */   1, 0 },
    { /* 70 */   2, 0 },
    { /* 71 */   0, 0 },
    { /* 72 */  23, 24 },
    { /* 73 */  24, 25 },
    { /* 74 */  25, 26 },
    { /* 75 */  26, 27 },
    { /* 76 */  27, 28 },
    { /* 77 */  28, 29 },
    { /* 78 */  29, 30 },
    { /* 79 */  30, 31 },
    { /* 80 */  31, 32 },
    { /* 81 */  32, 33 },
    { /* 82 */  33, 34 },
    { /* 83 */  34, 35 },
    { /* 84 */  35, 36 },
    { /* 85 */  36, 37 },
    { /* 86 */  37, 38 },
    { /* 87 */  38, 39 },
    { /* 88 */  39, 40 },
    { /* 89 */  40, 41 },
    { /* 90 */  41, 42 },
    { /* 91 */  42, 43 },
    { /* 92 */  43, 44 },
    { /* 93 */  44, 45 },
    { /* 94 */  45, 46 },
    { /* 95 */   98, 0 },
    { /* 96 */   99, 0 },
    { /* 97 */  100, 0 },
    { /* 98 */  101, 0 },
    { /* 99 */  102, 0 },
    { /* 00 */  117, 0 },
    { /* 01 */   97, 0 },
    { /* 02 */   91, 0 },
    { /* 03 */   92, 0 },
    { /* 04 */   93, 0 },
    { /* 05 */   94, 0 },
    { /* 06 */   95, 0 },
    { /* 07 */   96, 0 },
    { /* 08 */  104, 0 },
    { /* 09 */  111, 0 },
    { /* 10 */  112, 0 },
    { /* 11 */  113, 0 },
    { /* 12 */  114, 0 },
    { /* 13 */  115, 0 },
    { /* 14 */  116, 0 },
    { /* 15 */  110, 0 },
    { /* 16 */  105, 0 },
    { /* 17 */  106, 0 },
    { /* 18 */  107, 0 },
    { /* 19 */  108, 0 },
    { /* 20 */  109, 0 },
    { /* 21 */  118, 0 },
    { /* 22 */    6, 0 },
    { /* 23 */    8, 0 },
    { /* 24 */    9, 0 },
    { /* 25 */   10, 0 },
    { /* 26 */    5, 0 },
    { /* 27 */  103, 0 },
    { /* 28 */  120, 0 },
    { /* 29 */  119, 0 },
    { /* 30 */    4, 0 },
    { /* 31 */    7, 0 },
    { /* 32 */   15, 0 },
    { /* 33 */   16, 0 },
    { /* 34 */   18, 0 },
    { /* 35 */   20, 0 },
    { /* 36 */   17, 0 },
    { /* 37 */   11, 0 },
    { /* 38 */   12, 0 },
    { /* 39 */   14, 0 },
    { /* 40 */   13, 0 }
};

const std::int8_t tHuffmanEnv15dB[120][2] = {
    {   1,   2 },    { -64, -65 },    {   3,   4 },    { -63, -66 },
    {   5,   6 },    { -62, -67 },    {   7,   8 },    { -61, -68 },
    {   9,  10 },    { -60, -69 },    {  11,  12 },    { -59, -70 },
    {  13,  14 },    { -58, -71 },    {  15,  16 },    { -57, -72 },
    {  17,  18 },    { -73, -56 },    {  19,  21 },    { -74,  20 },
    { -55, -75 },    {  22,  26 },    {  23,  24 },    { -54, -76 },
    { -77,  25 },    { -53, -78 },    {  27,  34 },    {  28,  29 },
    { -52, -79 },    {  30,  31 },    { -80, -51 },    {  32,  33 },
    { -83, -82 },    { -81, -50 },    {  35,  57 },    {  36,  40 },
    {  37,  38 },    { -88, -84 },    { -48,  39 },    { -90, -85 },
    {  41,  46 },    {  42,  43 },    { -49, -87 },    {  44,  45 },
    { -89, -86 },    {-124,-123 },    {  47,  50 },    {  48,  49 },
    {-122,-121 },    {-120,-119 },    {  51,  54 },    {  52,  53 },
    {-118,-117 },    {-116,-115 },    {  55,  56 },    {-114,-113 },
    {-112,-111 },    {  58,  89 },    {  59,  74 },    {  60,  67 },
    {  61,  64 },    {  62,  63 },    {-110,-109 },    {-108,-107 },
    {  65,  66 },    {-106,-105 },    {-104,-103 },    {  68,  71 },
    {  69,  70 },    {-102,-101 },    {-100, -99 },    {  72,  73 },
    { -98, -97 },    { -96, -95 },    {  75,  82 },    {  76,  79 },
    {  77,  78 },    { -94, -93 },    { -92, -91 },    {  80,  81 },
    { -47, -46 },    { -45, -44 },    {  83,  86 },    {  84,  85 },
    { -43, -42 },    { -41, -40 },    {  87,  88 },    { -39, -38 },
    { -37, -36 },    {  90, 105 },    {  91,  98 },    {  92,  95 },
    {  93,  94 },    { -35, -34 },    { -33, -32 },    {  96,  97 },
    { -31, -30 },    { -29, -28 },    {  99, 102 },    { 100, 101 },
    { -27, -26 },    { -25, -24 },    { 103, 104 },    { -23, -22 },
    { -21, -20 },    { 106, 113 },    { 107, 110 },    { 108, 109 },
    { -19, -18 },    { -17, -16 },    { 111, 112 },    { -15, -14 },
    { -13, -12 },    { 114, 117 },    { 115, 116 },    { -11, -10 },
    {  -9,  -8 },    { 118, 119 },    {  -7,  -6 },    {  -5,  -4 }
};

const std::int8_t fHuffmanEnv15dB[120][2] = {
    {   1,   2 },    { -64, -65 },    {   3,   4 },    { -63, -66 },
    {   5,   6 },    { -67, -62 },    {   7,   8 },    { -68, -61 },
    {   9,  10 },    { -69, -60 },    {  11,  13 },    { -70,  12 },
    { -59, -71 },    {  14,  16 },    { -58,  15 },    { -72, -57 },
    {  17,  19 },    { -73,  18 },    { -56, -74 },    {  20,  23 },
    {  21,  22 },    { -55, -75 },    { -54, -53 },    {  24,  27 },
    {  25,  26 },    { -76, -52 },    { -77, -51 },    {  28,  31 },
    {  29,  30 },    { -50, -78 },    { -79, -49 },    {  32,  36 },
    {  33,  34 },    { -48, -47 },    { -80,  35 },    { -81, -82 },
    {  37,  47 },    {  38,  41 },    {  39,  40 },    { -83, -46 },
    { -45, -84 },    {  42,  44 },    { -85,  43 },    { -44, -43 },
    {  45,  46 },    { -88, -87 },    { -86, -90 },    {  48,  66 },
    {  49,  56 },    {  50,  53 },    {  51,  52 },    { -92, -42 },
    { -41, -39 },    {  54,  55 },    {-105, -89 },    { -38, -37 },
    {  57,  60 },    {  58,  59 },    { -94, -91 },    { -40, -36 },
    {  61,  63 },    { -20,  62 },    {-115,-110 },    {  64,  65 },
    {-108,-107 },    {-101, -97 },    {  67,  89 },    {  68,  75 },
    {  69,  72 },    {  70,  71 },    { -95, -93 },    { -34, -27 },
    {  73,  74 },    { -22, -17 },    { -16,-124 },    {  76,  82 },
    {  77,  79 },    {-123,  78 },    {-122,-121 },    {  80,  81 },
    {-120,-119 },    {-118,-117 },    {  83,  86 },    {  84,  85 },
    {-116,-114 },    {-113,-112 },    {  87,  88 },    {-111,-109 },
    {-106,-104 },    {  90, 105 },    {  91,  98 },    {  92,  95 },
    {  93,  94 },    {-103,-102 },    {-100, -99 },    {  96,  97 },
    { -98, -96 },    { -35, -33 },    {  99, 102 },    { 100, 101 },
    { -32, -31 },    { -30, -29 },    { 103, 104 },    { -28, -26 },
    { -25, -24 },    { 106, 113 },    { 107, 110 },    { 108, 109 },
    { -23, -21 },    { -19, -18 },    { 111, 112 },    { -15, -14 },
    { -13, -12 },    { 114, 117 },    { 115, 116 },    { -11, -10 },
    {  -9,  -8 },    { 118, 119 },    {  -7,  -6 },    {  -5,  -4 }
};

const std::int8_t tHuffmanEnvBal15dB[48][2] = {
    { -64,   1 },    { -63,   2 },    { -65,   3 },    { -62,   4 },
    { -66,   5 },    { -61,   6 },    { -67,   7 },    { -60,   8 },
    { -68,   9 },    {  10,  11 },    { -69, -59 },    {  12,  13 },
    { -70, -58 },    {  14,  28 },    {  15,  21 },    {  16,  18 },
    { -57,  17 },    { -71, -56 },    {  19,  20 },    { -88, -87 },
    { -86, -85 },    {  22,  25 },    {  23,  24 },    { -84, -83 },
    { -82, -81 },    {  26,  27 },    { -80, -79 },    { -78, -77 },
    {  29,  36 },    {  30,  33 },    {  31,  32 },    { -76, -75 },
    { -74, -73 },    {  34,  35 },    { -72, -55 },    { -54, -53 },
    {  37,  41 },    {  38,  39 },    { -52, -51 },    { -50,  40 },
    { -49, -48 },    {  42,  45 },    {  43,  44 },    { -47, -46 },
    { -45, -44 },    {  46,  47 },    { -43, -42 },    { -41, -40 }
};

const std::int8_t fHuffmanEnvBal15dB[48][2] = {
    { -64,   1 },    { -65,   2 },    { -63,   3 },    { -66,   4 },
    { -62,   5 },    { -61,   6 },    { -67,   7 },    { -68,   8 },
    { -60,   9 },    {  10,  11 },    { -69, -59 },    { -70,  12 },
    { -58,  13 },    {  14,  17 },    { -71,  15 },    { -57,  16 },
    { -56, -73 },    {  18,  32 },    {  19,  25 },    {  20,  22 },
    { -72,  21 },    { -88, -87 },    {  23,  24 },    { -86, -85 },
    { -84, -83 },    {  26,  29 },    {  27,  28 },    { -82, -81 },
    { -80, -79 },    {  30,  31 },    { -78, -77 },    { -76, -75 },
    {  33,  40 },    {  34,  37 },    {  35,  36 },    { -74, -55 },
    { -54, -53 },    {  38,  39 },    { -52, -51 },    { -50, -49 },
    {  41,  44 },    {  42,  43 },    { -48, -47 },    { -46, -45 },
    {  45,  46 },    { -44, -43 },    { -42,  47 },    { -41, -40 }
};

const std::int8_t tHuffmanEnv30dB[62][2] = {
    { -64,   1 },    { -65,   2 },    { -63,   3 },    { -66,   4 },
    { -62,   5 },    { -67,   6 },    { -61,   7 },    { -68,   8 },
    { -60,   9 },    {  10,  11 },    { -69, -59 },    {  12,  14 },
    { -70,  13 },    { -71, -58 },    {  15,  18 },    {  16,  17 },
    { -72, -57 },    { -73, -74 },    {  19,  22 },    { -56,  20 },
    { -55,  21 },    { -54, -77 },    {  23,  31 },    {  24,  25 },
    { -75, -76 },    {  26,  27 },    { -78, -53 },    {  28,  29 },
    { -52, -95 },    { -94,  30 },    { -93, -92 },    {  32,  47 },
    {  33,  40 },    {  34,  37 },    {  35,  36 },    { -91, -90 },
    { -89, -88 },    {  38,  39 },    { -87, -86 },    { -85, -84 },
    {  41,  44 },    {  42,  43 },    { -83, -82 },    { -81, -80 },
    {  45,  46 },    { -79, -51 },    { -50, -49 },    {  48,  55 },
    {  49,  52 },    {  50,  51 },    { -48, -47 },    { -46, -45 },
    {  53,  54 },    { -44, -43 },    { -42, -41 },    {  56,  59 },
    {  57,  58 },    { -40, -39 },    { -38, -37 },    {  60,  61 },
    { -36, -35 },    { -34, -33 }
};

const std::int8_t fHuffmanEnv30dB[62][2] = {
    { -64,   1 },    { -65,   2 },    { -63,   3 },    { -66,   4 },
    { -62,   5 },    { -67,   6 },    {   7,   8 },    { -61, -68 },
    {   9,  10 },    { -60, -69 },    {  11,  12 },    { -59, -70 },
    {  13,  14 },    { -58, -71 },    {  15,  16 },    { -57, -72 },
    {  17,  19 },    { -56,  18 },    { -55, -73 },    {  20,  24 },
    {  21,  22 },    { -74, -54 },    { -53,  23 },    { -75, -76 },
    {  25,  30 },    {  26,  27 },    { -52, -51 },    {  28,  29 },
    { -77, -79 },    { -50, -49 },    {  31,  39 },    {  32,  35 },
    {  33,  34 },    { -78, -46 },    { -82, -88 },    {  36,  37 },
    { -83, -48 },    { -47,  38 },    { -86, -85 },    {  40,  47 },
    {  41,  44 },    {  42,  43 },    { -80, -44 },    { -43, -42 },
    {  45,  46 },    { -39, -87 },    { -84, -40 },    {  48,  55 },
    {  49,  52 },    {  50,  51 },    { -95, -94 },    { -93, -92 },
    {  53,  54 },    { -91, -90 },    { -89, -81 },    {  56,  59 },
    {  57,  58 },    { -45, -41 },    { -38, -37 },    {  60,  61 },
    { -36, -35 },    { -34, -33 }
};

const std::int8_t tHuffmanEnvBal30dB[24][2] = {
    { -64,   1 },    { -63,   2 },    { -65,   3 },    { -66,   4 },
    { -62,   5 },    { -61,   6 },    { -67,   7 },    { -68,   8 },
    { -60,   9 },    {  10,  16 },    {  11,  13 },    { -69,  12 },
    { -76, -75 },    {  14,  15 },    { -74, -73 },    { -72, -71 },
    {  17,  20 },    {  18,  19 },    { -70, -59 },    { -58, -57 },
    {  21,  22 },    { -56, -55 },    { -54,  23 },    { -53, -52 }
};

const std::int8_t fHuffmanEnvBal30dB[24][2] = {
    { -64,   1 },    { -65,   2 },    { -63,   3 },    { -66,   4 },
    { -62,   5 },    { -61,   6 },    { -67,   7 },    { -68,   8 },
    { -60,   9 },    {  10,  13 },    { -69,  11 },    { -59,  12 },
    { -58, -76 },    {  14,  17 },    {  15,  16 },    { -75, -74 },
    { -73, -72 },    {  18,  21 },    {  19,  20 },    { -71, -70 },
    { -57, -56 },    {  22,  23 },    { -55, -54 },    { -53, -52 }
};

const std::int8_t tHuffmanNoise30dB[62][2] = {
    { -64,   1 },    { -63,   2 },    { -65,   3 },    { -66,   4 },
    { -62,   5 },    { -67,   6 },    {   7,   8 },    { -61, -68 },
    {   9,  30 },    {  10,  15 },    { -60,  11 },    { -69,  12 },
    {  13,  14 },    { -59, -53 },    { -95, -94 },    {  16,  23 },
    {  17,  20 },    {  18,  19 },    { -93, -92 },    { -91, -90 },
    {  21,  22 },    { -89, -88 },    { -87, -86 },    {  24,  27 },
    {  25,  26 },    { -85, -84 },    { -83, -82 },    {  28,  29 },
    { -81, -80 },    { -79, -78 },    {  31,  46 },    {  32,  39 },
    {  33,  36 },    {  34,  35 },    { -77, -76 },    { -75, -74 },
    {  37,  38 },    { -73, -72 },    { -71, -70 },    {  40,  43 },
    {  41,  42 },    { -58, -57 },    { -56, -55 },    {  44,  45 },
    { -54, -52 },    { -51, -50 },    {  47,  54 },    {  48,  51 },
    {  49,  50 },    { -49, -48 },    { -47, -46 },    {  52,  53 },
    { -45, -44 },    { -43, -42 },    {  55,  58 },    {  56,  57 },
    { -41, -40 },    { -39, -38 },    {  59,  60 },    { -37, -36 },
    { -35,  61 },    { -34, -33 }
};

const std::int8_t tHuffmanNoiseBal30dB[24][2] = {
    { -64,   1 },    { -65,   2 },    { -63,   3 },    {   4,   9 },
    { -66,   5 },    { -62,   6 },    {   7,   8 },    { -76, -75 },
    { -74, -73 },    {  10,  17 },    {  11,  14 },    {  12,  13 },
    { -72, -71 },    { -70, -69 },    {  15,  16 },    { -68, -67 },
    { -61, -60 },    {  18,  21 },    {  19,  20 },    { -59, -58 },
    { -57, -56 },    {  22,  23 },    { -55, -54 },    { -53, -52 }
};
// clang-format on

/// \endcond

} // namespace TagParser
