# Rust `rust`

!!! important "Типово ця секція обробляється асинхронно"

!!! info "Інформація"
    [**Rust**](https://www.rust-lang.org) – це мова системного програмування, яка зосереджена на безпеці, швидкості та паралелізмі.

Секція `rust` відображає версію Rust.

Ця секція відображається лише тоді, коли поточний каталог знаходиться у Rust-проєкті, тобто:

* Пошук вгору знаходить файл `Cargo.toml`
* Поточна папка містить будь-який файл `.rs`

## Відображення детальної версії

Типово ця секція прибиратиме все суфікси з номера версії. Наприклад, `1.42.0-nightly.2020-06-09` буде показуватись як `1.42.0`. Для вимкнення такої поведінки використовуйте змінну середовища `SPACESHIP_RUST_VERBOSE_VERSION`.

```zsh title=".zshrc"
# Докладний показ версії
SPACESHIP_RUST_VERBOSE_VERSION=true
```

## Опції

| Змінна                           |          За замовчуванням          | Пояснення                                        |
|:-------------------------------- |:----------------------------------:| ------------------------------------------------ |
| `SPACESHIP_RUST_SHOW`            |               `true`               | Показати секцію                                  |
| `SPACESHIP_RUST_ASYNC`           |               `true`               | Рендерити секцію асинхронно                      |
| `SPACESHIP_RUST_PREFIX`          | `$SPACESHIP_PROMPT_DEFAULT_PREFIX` | Префікс секції                                   |
| `SPACESHIP_RUST_SUFFIX`          | `$SPACESHIP_PROMPT_DEFAULT_SUFFIX` | Суфікс секції                                    |
| `SPACESHIP_RUST_SYMBOL`          |                `🦀·`                | Символ, що відображається перед секцією          |
| `SPACESHIP_RUST_COLOR`           |               `red`                | Колір секції                                     |
| `SPACESHIP_RUST_VERBOSE_VERSION` |              `false`               | Показує яка гілка використовується, якщо такі є. |
