# Розділювач рядків `line_sep`

Секція `line_sep` використовується як розділювач рядків у командному рядку.

## Додавання додаткових розривів рядків в командний рядок

Ви можете додати більше розривів рядків до командного рядка, додавши більше секцій `line_sep`, там де вам потрібно. Для цього можна скористатись командою `spaceship add`:

```zsh title=".zshrc"
# Додає рядок розриву після секції git
spaceship add --after git line_sep

# Додає рядок розриву перед секцією char
spaceship add --before char line_sep
```

## Вимкнення роздільника рядків

Ви можете уникнути додавання розділювача рядків встановивши `SPACESHIP_PROMPT_SEPARATE_LINE` в `false`.

```zsh title=".zshrc"
# Уникає обробки line_sep
SPACESHIP_PROMPT_SEPARATE_LINE=false
```

## Видалення `line_sep` командного рядка

Ви можете видалити `line_sep` з командного рядка цілком наступним чином:

```zsh title=".zshrc"
spaceship remove line_sep
```

## Опції

| Змінна                           | За замовчуванням | Пояснення                      |
|:-------------------------------- |:----------------:| ------------------------------ |
| `SPACESHIP_PROMPT_SEPARATE_LINE` |      `true`      | Відображати розділювачі рядків |
