# Elixir `elixir`

!!! important "Типово ця секція обробляється асинхронно"

!!! info "Інформація"
    [**Elixir**](https://elixir-lang.org) — динамічна, функціональна мова програмування для створення масштабованих, добре підтримуваних застосунків.

Секція `elixir` відображає версію Elixir.

Ця секція відображається лише тоді, коли поточна директорія:

* Містить файл `mix.exs`
* Містить будь-який інший файл з розширенням `.ex` або `.exs`

## Встановлення версії Elixir за замовчуванням

Якщо ви бажаєте уникнути показу секції Elexir для певних версій (наприклад, версії встановленої разом з системою), використовуйте змінну `SPACESHIP_ELIXIR_DEFAULT_VERSION`. Секцію буде приховано, якщо поточна версія Elixir збігається зі значенням змінної.

```zsh title=".zshrc"
SPACESHIP_ELIXIR_DEFAULT_VERSION="1.13.4"
```

## Параметри

| Змінна                             |          За замовчуванням          | Пояснення                               |
|:---------------------------------- |:----------------------------------:| --------------------------------------- |
| `SPACESHIP_ELIXIR_SHOW`            |               `true`               | Показати секцію                         |
| `SPACESHIP_ELIXIR_ASYNC`           |               `true`               | Рендерити секцію асинхронно             |
| `SPACESHIP_ELIXIR_PREFIX`          | `$SPACESHIP_PROMPT_DEFAULT_PREFIX` | Префікс секції                          |
| `SPACESHIP_ELIXIR_SUFFIX`          | `$SPACESHIP_PROMPT_DEFAULT_SUFFIX` | Суфікс секції                           |
| `SPACESHIP_ELIXIR_DEFAULT_VERSION` |                 -                  | Версія Elixir, яку слід вважати типовою |
| `SPACESHIP_ELIXIR_SYMBOL`          |                `💧·`                | Символ перед секцією                    |
| `SPACESHIP_ELIXIR_COLOR`           |             `magenta`              | Колір секції                            |
