# Директорія `dir`

Секція `dir` показує поточну робочу теку.

Тека завжди показується у скороченому вигляді використовуючи `SPACESHIP_DIR_TRUNC` (до 3 рівнів).

## Всередині репозиторіїв

Поки ви перебуваєте в репозиторії, показується тільки коренева тека репозиторію і теки всередині нього.

Якщо вам не подобається така поведінка, ви можете вимкнути її, встановивши `SPACESHIP_DIR_TRUNC_REPO` у `false`:

```zsh title=".zshrc"
SPACESHIP_DIR_TRUNC_REPO=false
```

## Всередині каталогів, захищених від запису

Якщо поточна тека захищена від запису або поточний користувач не має дозволу на запис, (типово) показується замок в суфіксі.

## Параметри

| Змінна                       |          За замовчуванням          | Пояснення                                                                               |
|:---------------------------- |:----------------------------------:| --------------------------------------------------------------------------------------- |
| `SPACESHIP_DIR_SHOW`         |               `true`               | Показати секцію                                                                         |
| `SPACESHIP_DIR_PREFIX`       |               `in·`                | Префікс секції                                                                          |
| `SPACESHIP_DIR_SUFFIX`       | `$SPACESHIP_PROMPT_DEFAULT_SUFFIX` | Суфікс секції                                                                           |
| `SPACESHIP_DIR_TRUNC`        |                `3`                 | Кількість тек cwd, що показуються в командному рядку, 0 для показу всіх                 |
| `SPACESHIP_DIR_TRUNC_PREFIX` |                 -                  | Префікс до cwd під час обрізання. Наприклад, `…/` або `.../`, порожнє, щоб вимкнути     |
| `SPACESHIP_DIR_TRUNC_REPO`   |               `true`               | Під час знаходження в `git` репозиторії, показати тільки кореневу теку і теки всередині |
| `SPACESHIP_DIR_COLOR`        |               `cyan`               | Колір секції                                                                            |
| `SPACESHIP_DIR_LOCK_SYMBOL`  |              ![·][1]              | Символ, що показується, якщо теку захищено від запису                                   |
| `SPACESHIP_DIR_LOCK_COLOR`   |               `red`                | Колір символу блокування                                                                |

<!-- References -->

[1]: https://user-images.githubusercontent.com/10276208/46248218-4af95d80-c434-11e8-8e25-595d792503f1.png
