# Батарея `battery`

!!! important "За замовчуванням ця секція рендериться асинхронно"

Секція `battery` показує поточний стан батареї та рівень заряду.

Типово, секція `battery` показується тільки якщо рівень заряду нижчий ніж `SPACESHIP_BATTERY_THRESHOLD` (типово 10%).

## Керування показом секції `battery`

Ви можете показувати секцію `battery` постійно або коли батарею повністю заряджено, чи розряджено. Доволі легко контролювати, коли показати секцію ` battery`, скориставшись параметром `SPACESHIP_BATTERY_SHOW`.

Ось можливі значення:

| `SPACESHIP_BATTERY_SHOW` | Нижче порогу | Вище порогу | Повністю заряджена |
|:------------------------:|:------------ |:----------- |:------------------ |
|         `false`          | Приховано    | Приховано   | Приховано          |
|         `always`         | Показано     | Показано    | Показано           |
|          `true`          | Показано     | Приховано   | Приховано          |
|        `charged`         | Показано     | Приховано   | Показано           |

## Параметри

| Змінна                                 |          За замовчуванням          | Пояснення                                                                |
|:-------------------------------------- |:----------------------------------:| ------------------------------------------------------------------------ |
| `SPACESHIP_BATTERY_SHOW`               |               `true`               | Показувати секцію (`true`, `false`, `always` або `charged`)              |
| `SPACESHIP_BATTERY_ASYNC`              |               `true`               | Рендерити секцію асинхронно                                              |
| `SPACESHIP_BATTERY_PREFIX`             |                 ``                 | Префікс підсекції                                                        |
| `SPACESHIP_BATTERY_SUFFIX`             | `$SPACESHIP_PROMPT_DEFAULT_SUFFIX` | Суфікс секції                                                            |
| `SPACESHIP_BATTERY_SYMBOL_CHARGING`    |                `⇡`                 | Символ, що показується на початку секції під час заряджання батареї      |
| `SPACESHIP_BATTERY_SYMBOL_DISCHARGING` |                `⇣`                 | Символ, який показується на початку секції, коли батарея розряджається   |
| `SPACESHIP_BATTERY_SYMBOL_FULL`        |                `•`                 | Символ, що показується на початку секції, коли батарея заряджена на 100% |
| `SPACESHIP_BATTERY_THRESHOLD`          |                 10                 | Рівень заряду батареї, нижче якого секцію буде показано                  |

