---
template: index.html
title: Minimalistic, powerful and extremely customizable Zsh prompt
hide: [navigation]
hero:
  title: Minimalistic, powerful and extremely customizable Zsh prompt
  subtitle: It combines everything you may need for convenient work, without unnecessary complications, like a real spaceship.
  install_button: Getting Started
  source_button: Source Code
features:
  - title: Clean and simple
    image: /assets/images/what-is-needed.svg
    description: The prompt is not overloaded, it shows only what you need at the moment (current directory, git branch, etc).
  - title: Easy to set up
    image: /assets/images/out-of-the-box.svg
    description: The prompt works right after installation without any additional configuration. install it and use it.
  - title: Configurable
    image: /assets/images/configurable.svg
    description: The prompt is zero-config, but if a customization is needed, it provides an easy-to-use interface for customization.
companies:
  title:  Used daily by marvelous folks at
  list:
    - name: Wix
      logo: https://cdn.svgporn.com/logos/wix.svg
    - name: Google
      logo: https://cdn.svgporn.com/logos/google.svg
    - name: Siemens
      logo: https://upload.wikimedia.org/wikipedia/commons/5/5f/Siemens-logo.svg
    - name: Microsoft
      logo: https://cdn.svgporn.com/logos/microsoft.svg
    - name: Adobe
      logo: https://upload.wikimedia.org/wikipedia/commons/6/6e/Adobe_Corporate_logo.svg
    - name: Docker
      logo: https://cdn.svgporn.com/logos/docker.svg
    - name: Shopify
      logo: https://upload.wikimedia.org/wikipedia/commons/0/0e/Shopify_logo_2018.svg
    - name: GitHub
      logo: https://cdn.svgporn.com/logos/github.svg
    - name: Red Hat
      logo: https://cdn.svgporn.com/logos/redhat.svg
    - name: Amazon Web Services
      logo: https://cdn.svgporn.com/logos/aws.svg
    - name: Facebook
      logo: https://cdn.worldvectorlogo.com/logos/facebook-7.svg
    - name: npm
      logo: https://cdn.svgporn.com/logos/npm.svg
    - name: Unity Technologies
      logo: https://cdn.worldvectorlogo.com/logos/unity-technologies-logo.svg
    - name: Angular
      logo: https://cdn.svgporn.com/logos/angular.svg
    - name: Mozilla
      logo: https://cdn.svgporn.com/logos/mozilla.svg
    - name: Framer
      logo: https://cdn.svgporn.com/logos/framer.svg
    - name: Grammarly
      logo: https://cdn.svgporn.com/logos/grammarly.svg
    - name: Skyscanner
      logo: https://upload.wikimedia.org/wikipedia/commons/9/94/Skyscanner_Logo_LockupHorizontal_SkyBlue_RGB.svg
    - name: Node.js
      logo: https://cdn.svgporn.com/logos/nodejs.svg
    - name: Vue Storefront
      logo: https://cdn.worldvectorlogo.com/logos/vue-storefront.svg
    - name: Coinbase
      logo: https://cdn.worldvectorlogo.com/logos/coinbase-1.svg
    - name: Suse
      logo: https://cdn.svgporn.com/logos/suse.svg
---

# Welcome aboard, Astronaut!

[![SWUbanner](https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/banner-direct-single.svg)](https://stand-with-ukraine.pp.ua)

<div class="terminal-demo">
  <script id="asciicast-513451" src="https://asciinema.org/a/513451.js" data-autoplay="true" data-loop="true" data-preload="true" async></script>
  <noscript>
    <object class="asciicast" type="image/svg+xml" data="/assets/images/spaceship-demo.svg">
      <img src="/assets/images/spaceship-demo.gif" alt="Spaceship demo" />
    </object>
  </noscript>
</div>

## Features

**Spaceship** is a superpowered Zsh prompt. Prompt is what you see when you type a command. It can show a lot of useful tips, saving your time and making user experience smooth and pleasant.

Here are some sneak picks of what **Spaceship** can show:

- Clever hostname and username displaying
- Repository statuses (Git and Mercurial are supported)
- Runtime environments for various languages (Node.js, Rust, Python, Ruby, Swift, Go, PHP and many others)
- Docker version, Kubernetes context and connected machine
- Package version (npm, lerna, cargo, composer and others)
- Battery level and status
- Indicator for jobs in the background `✦`
- A lot of [useful information](sections/index.md)
- Custom [information of your choice](advanced/creating-section.md)

Want more features? Please, [open an issue](https://github.com/spaceship-prompt/yspaceship-prompt/issues/new/choose) or send pull request.

## Getting Started

Installing Spaceship is simple and quick. It's configurable and easy to use.

[Installation](getting-started.md){ .md-button  }
[Configuration](config/intro.md){ .md-button }

## Support

Join our community and consider contributing to the project.

[:material-hand-heart: Contribute](contribute.md){ .md-button }
[:fontawesome-brands-twitter: Twitter](https://twitter.com/SpaceshipPrompt){ .md-button }
[:fontawesome-brands-discord: Discord](https://discord.gg/NTQWz8Dyt9){ .md-button }
[:fontawesome-brands-github: Discussions](https://github.com/spaceship-prompt/spaceship-prompt/discussions/){ .md-button }

## License

MIT © [Denys Dovhan](http://denysdovhan.com)

<!-- markdownlint-disable-next-line MD053 -->
[^1]: The list of companies and projects whose contributors are using Spaceship is assembled based on individuals who opened an issue or pull request in Spaceship's repository and explicitly mentioned their affiliation with those companies or projects.
