---
title: npm-config
section: 1
description: Manage the npm configuration files
---

### Synopsis

<!-- AUTOGENERATED USAGE DESCRIPTIONS -->

### Description

npm gets its config settings from the command line, environment
variables, `npmrc` files, and in some cases, the `package.json` file.

See [npmrc](/configuring-npm/npmrc) for more information about the npmrc
files.

See [config](/using-npm/config) for a more thorough explanation of the
mechanisms involved, and a full list of config options available.

The `npm config` command can be used to update and edit the contents
of the user and global npmrc files.

### Sub-commands

Config supports the following sub-commands:

#### set

```bash
npm config set key=value [key=value...]
npm set key=value [key=value...]
```

Sets each of the config keys to the value provided. Modifies the user configuration
file unless [`location`](/commands/npm-config#location) is passed.

If value is omitted, the key will be removed from your config file entirely.

Note: for backwards compatibility, `npm config set key value` is supported
as an alias for `npm config set key=value`.

#### get

```bash
npm config get [key ...]
npm get [key ...]
```

Echo the config value(s) to stdout.

If multiple keys are provided, then the values will be prefixed with the
key names.

If no keys are provided, then this command behaves the same as `npm config
list`.

#### list

```bash
npm config list
```

Show all the config settings. Use `-l` to also show defaults. Use `--json`
to show the settings in json format.

#### delete

```bash
npm config delete key [key ...]
```

Deletes the specified keys from all configuration files.

#### edit

```bash
npm config edit
```

Opens the config file in an editor.  Use the `--global` flag to edit the
global config.

#### fix

```bash
npm config fix
```

Attempts to repair invalid configuration items.  Usually this means
attaching authentication config (i.e. `_auth`, `_authToken`) to the
configured `registry`.

### Configuration

<!-- AUTOGENERATED CONFIG DESCRIPTIONS -->

### See Also

* [npm folders](/configuring-npm/folders)
* [npm config](/commands/npm-config)
* [package.json](/configuring-npm/package-json)
* [npmrc](/configuring-npm/npmrc)
* [npm](/commands/npm)
