; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx | FileCheck %s --check-prefixes=XOP,XOPAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx2 | FileCheck %s --check-prefixes=XOP,XOPAVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512BW

; Shifts of uniform vXi8 constant values can be performed by a PSHUFB LUT

define <16 x i8> @uniform_shl_v16i8(<16 x i8> %a) nounwind {
; SSE2-LABEL: uniform_shl_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    paddb %xmm3, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE2-NEXT:    psubb %xmm3, %xmm0
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pandn %xmm0, %xmm4
; SSE2-NEXT:    psllw $2, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm4, %xmm0
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm1
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_shl_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uniform_shl_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; XOP-LABEL: uniform_shl_v16i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOP-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_shl_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_shl_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512BW-NEXT:    retq
  %shift = shl <16 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>, %a
  ret <16 x i8> %shift
}

define <16 x i8> @uniform_lshr_v16i8(<16 x i8> %a) nounwind {
; SSE2-LABEL: uniform_lshr_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $5, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    paddb %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    pandn %xmm1, %xmm0
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_lshr_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm1 = [2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uniform_lshr_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = [2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; XOP-LABEL: uniform_lshr_v16i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; XOP-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOP-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_lshr_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovd {{.*#+}} xmm1 = [2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_lshr_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovd {{.*#+}} xmm1 = [2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512BW-NEXT:    retq
  %shift = lshr <16 x i8> <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>, %a
  ret <16 x i8> %shift
}

define <16 x i8> @uniform_ashr_v16i8(<16 x i8> %a) nounwind {
; SSE2-LABEL: uniform_ashr_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $5, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    paddb %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    pandn %xmm1, %xmm0
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_ashr_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm1 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uniform_ashr_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; XOP-LABEL: uniform_ashr_v16i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; XOP-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOP-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_ashr_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovd {{.*#+}} xmm1 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_ashr_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovd {{.*#+}} xmm1 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <16 x i8> <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>, %a
  ret <16 x i8> %shift
}

define <32 x i8> @uniform_shl_v32i8(<32 x i8> %a) nounwind {
; SSE2-LABEL: uniform_shl_v32i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; SSE2-NEXT:    movdqa %xmm7, %xmm0
; SSE2-NEXT:    pandn %xmm4, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; SSE2-NEXT:    pand %xmm5, %xmm7
; SSE2-NEXT:    por %xmm0, %xmm7
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm8
; SSE2-NEXT:    pandn %xmm7, %xmm8
; SSE2-NEXT:    psllw $2, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    pand %xmm7, %xmm0
; SSE2-NEXT:    por %xmm8, %xmm0
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm7
; SSE2-NEXT:    movdqa %xmm7, %xmm2
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pand %xmm7, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm7
; SSE2-NEXT:    movdqa %xmm7, %xmm2
; SSE2-NEXT:    pandn %xmm4, %xmm2
; SSE2-NEXT:    pand %xmm5, %xmm7
; SSE2-NEXT:    por %xmm2, %xmm7
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pandn %xmm7, %xmm4
; SSE2-NEXT:    psllw $2, %xmm7
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pand %xmm7, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pandn %xmm2, %xmm1
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_shl_v32i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq {{.*#+}} xmm2 = [4,8,16,32,64,128,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm2, %xmm3
; SSE41-NEXT:    pshufb %xmm0, %xmm3
; SSE41-NEXT:    pshufb %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uniform_shl_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovq {{.*#+}} xmm2 = [4,8,16,32,64,128,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uniform_shl_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: uniform_shl_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm2, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: uniform_shl_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_shl_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_shl_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0,4,8,16,32,64,128,0,0]
; AVX512BW-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    retq
  %shift = shl <32 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>, %a
  ret <32 x i8> %shift
}

define <32 x i8> @uniform_lshr_v32i8(<32 x i8> %a) nounwind {
; SSE2-LABEL: uniform_lshr_v32i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    psllw $5, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; SSE2-NEXT:    pandn %xmm4, %xmm0
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm7
; SSE2-NEXT:    pandn %xmm0, %xmm7
; SSE2-NEXT:    psrlw $2, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pand %xmm0, %xmm6
; SSE2-NEXT:    por %xmm7, %xmm6
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    por %xmm7, %xmm0
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm6
; SSE2-NEXT:    pandn %xmm4, %xmm6
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    psrlw $2, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    por %xmm7, %xmm4
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pandn %xmm4, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_lshr_v32i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm2 = [5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm2, %xmm3
; SSE41-NEXT:    pshufb %xmm0, %xmm3
; SSE41-NEXT:    pshufb %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uniform_lshr_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovd {{.*#+}} xmm2 = [5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uniform_lshr_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: uniform_lshr_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOPAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm1
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, %xmm3, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: uniform_lshr_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_lshr_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_lshr_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0,5,2,1,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    retq
  %shift = lshr <32 x i8> <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>, %a
  ret <32 x i8> %shift
}

define <32 x i8> @uniform_ashr_v32i8(<32 x i8> %a) nounwind {
; SSE2-LABEL: uniform_ashr_v32i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    psllw $5, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; SSE2-NEXT:    pandn %xmm4, %xmm0
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm7
; SSE2-NEXT:    pandn %xmm0, %xmm7
; SSE2-NEXT:    psrlw $2, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pand %xmm0, %xmm6
; SSE2-NEXT:    por %xmm7, %xmm6
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    por %xmm7, %xmm0
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm6
; SSE2-NEXT:    pandn %xmm4, %xmm6
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    psrlw $2, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    por %xmm7, %xmm4
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pandn %xmm4, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_ashr_v32i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm2 = [6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm2, %xmm3
; SSE41-NEXT:    pshufb %xmm0, %xmm3
; SSE41-NEXT:    pshufb %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uniform_ashr_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovd {{.*#+}} xmm2 = [6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uniform_ashr_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: uniform_ashr_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOPAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm1
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, %xmm3, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: uniform_ashr_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_ashr_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_ashr_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0,6,3,1,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    retq
  %shift = ashr <32 x i8> <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>, %a
  ret <32 x i8> %shift
}

define <64 x i8> @uniform_shl_v64i8(<64 x i8> %a) nounwind {
; SSE2-LABEL: uniform_shl_v64i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm9
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; SSE2-NEXT:    movdqa %xmm9, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112]
; SSE2-NEXT:    pand %xmm7, %xmm9
; SSE2-NEXT:    por %xmm0, %xmm9
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    pandn %xmm9, %xmm10
; SSE2-NEXT:    psllw $2, %xmm9
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; SSE2-NEXT:    pand %xmm8, %xmm0
; SSE2-NEXT:    pand %xmm9, %xmm0
; SSE2-NEXT:    por %xmm10, %xmm0
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm9
; SSE2-NEXT:    movdqa %xmm9, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm1
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pand %xmm9, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    psllw $5, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm9
; SSE2-NEXT:    movdqa %xmm9, %xmm1
; SSE2-NEXT:    pandn %xmm5, %xmm1
; SSE2-NEXT:    pand %xmm7, %xmm9
; SSE2-NEXT:    por %xmm1, %xmm9
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm10
; SSE2-NEXT:    pandn %xmm9, %xmm10
; SSE2-NEXT:    psllw $2, %xmm9
; SSE2-NEXT:    pand %xmm8, %xmm1
; SSE2-NEXT:    pand %xmm9, %xmm1
; SSE2-NEXT:    por %xmm10, %xmm1
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm9
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    pandn %xmm1, %xmm4
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pand %xmm9, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm9
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    pandn %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm7, %xmm9
; SSE2-NEXT:    por %xmm4, %xmm9
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm10
; SSE2-NEXT:    pandn %xmm9, %xmm10
; SSE2-NEXT:    psllw $2, %xmm9
; SSE2-NEXT:    pand %xmm8, %xmm4
; SSE2-NEXT:    pand %xmm9, %xmm4
; SSE2-NEXT:    por %xmm10, %xmm4
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm9
; SSE2-NEXT:    movdqa %xmm9, %xmm2
; SSE2-NEXT:    pandn %xmm4, %xmm2
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pand %xmm9, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    psllw $5, %xmm3
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm9
; SSE2-NEXT:    pandn %xmm5, %xmm9
; SSE2-NEXT:    pand %xmm7, %xmm2
; SSE2-NEXT:    por %xmm9, %xmm2
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm7
; SSE2-NEXT:    pandn %xmm2, %xmm7
; SSE2-NEXT:    psllw $2, %xmm2
; SSE2-NEXT:    pand %xmm8, %xmm5
; SSE2-NEXT:    pand %xmm2, %xmm5
; SSE2-NEXT:    por %xmm7, %xmm5
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm2
; SSE2-NEXT:    pandn %xmm5, %xmm2
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    por %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm5, %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_shl_v64i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq {{.*#+}} xmm4 = [7,14,28,56,112,224,192,128,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pshufb %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm6
; SSE41-NEXT:    pshufb %xmm1, %xmm6
; SSE41-NEXT:    movdqa %xmm4, %xmm7
; SSE41-NEXT:    pshufb %xmm2, %xmm7
; SSE41-NEXT:    pshufb %xmm3, %xmm4
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm1
; SSE41-NEXT:    movdqa %xmm7, %xmm2
; SSE41-NEXT:    movdqa %xmm4, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uniform_shl_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovq {{.*#+}} xmm3 = [7,14,28,56,112,224,192,128,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uniform_shl_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128]
; AVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: uniform_shl_v64i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm0, %xmm3, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: uniform_shl_v64i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; XOPAVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_shl_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_shl_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128,7,14,28,56,112,224,192,128]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %shift = shl <64 x i8> <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>, %a
  ret <64 x i8> %shift
}

define <64 x i8> @uniform_lshr_v64i8(<64 x i8> %a) nounwind {
; SSE2-LABEL: uniform_lshr_v64i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; SSE2-NEXT:    pandn %xmm6, %xmm0
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm8
; SSE2-NEXT:    pandn %xmm0, %xmm8
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    pandn %xmm8, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE2-NEXT:    pand %xmm7, %xmm0
; SSE2-NEXT:    pand %xmm8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    psllw $5, %xmm5
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm1
; SSE2-NEXT:    pandn %xmm6, %xmm1
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm8
; SSE2-NEXT:    pandn %xmm1, %xmm8
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pandn %xmm8, %xmm5
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    pand %xmm7, %xmm1
; SSE2-NEXT:    pand %xmm8, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    pandn %xmm6, %xmm5
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm8
; SSE2-NEXT:    pandn %xmm5, %xmm8
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    pandn %xmm8, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    pand %xmm7, %xmm5
; SSE2-NEXT:    pand %xmm8, %xmm5
; SSE2-NEXT:    por %xmm2, %xmm5
; SSE2-NEXT:    psllw $5, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm2
; SSE2-NEXT:    pandn %xmm6, %xmm2
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm6
; SSE2-NEXT:    pandn %xmm2, %xmm6
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    pandn %xmm6, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    pand %xmm7, %xmm3
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_lshr_v64i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbq {{.*#+}} xmm4 = [1,0]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pshufb %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm6
; SSE41-NEXT:    pshufb %xmm1, %xmm6
; SSE41-NEXT:    movdqa %xmm4, %xmm7
; SSE41-NEXT:    pshufb %xmm2, %xmm7
; SSE41-NEXT:    pshufb %xmm3, %xmm4
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm1
; SSE41-NEXT:    movdqa %xmm7, %xmm2
; SSE41-NEXT:    movdqa %xmm4, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uniform_lshr_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm3 = [1,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uniform_lshr_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [1,0,1,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: uniform_lshr_v64i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm3, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, %xmm4, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm4, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: uniform_lshr_v64i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [1,0,1,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; XOPAVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_lshr_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [1,0,1,0]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_lshr_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %shift = lshr <64 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>, %a
  ret <64 x i8> %shift
}

define <64 x i8> @uniform_ashr_v64i8(<64 x i8> %a) nounwind {
; SSE2-LABEL: uniform_ashr_v64i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; SSE2-NEXT:    pandn %xmm6, %xmm0
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm8
; SSE2-NEXT:    pandn %xmm0, %xmm8
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    pandn %xmm8, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE2-NEXT:    pand %xmm7, %xmm0
; SSE2-NEXT:    pand %xmm8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    psllw $5, %xmm5
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm1
; SSE2-NEXT:    pandn %xmm6, %xmm1
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm8
; SSE2-NEXT:    pandn %xmm1, %xmm8
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pandn %xmm8, %xmm5
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    pand %xmm7, %xmm1
; SSE2-NEXT:    pand %xmm8, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    pandn %xmm6, %xmm5
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm8
; SSE2-NEXT:    pandn %xmm5, %xmm8
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    pandn %xmm8, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    pand %xmm7, %xmm5
; SSE2-NEXT:    pand %xmm8, %xmm5
; SSE2-NEXT:    por %xmm2, %xmm5
; SSE2-NEXT:    psllw $5, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm2
; SSE2-NEXT:    pandn %xmm6, %xmm2
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm6
; SSE2-NEXT:    pandn %xmm2, %xmm6
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    pandn %xmm6, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    pand %xmm7, %xmm3
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uniform_ashr_v64i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm4 = [2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pshufb %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm6
; SSE41-NEXT:    pshufb %xmm1, %xmm6
; SSE41-NEXT:    movdqa %xmm4, %xmm7
; SSE41-NEXT:    pshufb %xmm2, %xmm7
; SSE41-NEXT:    pshufb %xmm3, %xmm4
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm1
; SSE41-NEXT:    movdqa %xmm7, %xmm2
; SSE41-NEXT:    movdqa %xmm4, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uniform_ashr_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovd {{.*#+}} xmm3 = [2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uniform_ashr_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: uniform_ashr_v64i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm3, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, %xmm4, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm1, %xmm4, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: uniform_ashr_v64i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; XOPAVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: uniform_ashr_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: uniform_ashr_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <64 x i8> <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>, %a
  ret <64 x i8> %shift
}

; Test where each 128-bit lane has a different value

define <32 x i8> @perlane_shl_v32i8(<32 x i8> %a) nounwind {
; SSE2-LABEL: perlane_shl_v32i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm5
; SSE2-NEXT:    por %xmm1, %xmm5
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    psllw $2, %xmm5
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    por %xmm6, %xmm1
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    psllw $5, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; SSE2-NEXT:    pand %xmm2, %xmm5
; SSE2-NEXT:    paddb %xmm2, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    psubb %xmm2, %xmm5
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    psllw $2, %xmm5
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pand %xmm5, %xmm2
; SSE2-NEXT:    por %xmm6, %xmm2
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    pandn %xmm2, %xmm0
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    por %xmm0, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: perlane_shl_v32i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm0, %xmm2
; SSE41-NEXT:    movq {{.*#+}} xmm3 = [2,4,8,16,32,64,128,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm3, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: perlane_shl_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovq {{.*#+}} xmm2 = [2,4,8,16,32,64,128,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovq {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: perlane_shl_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [1,2,4,8,16,32,64,128,u,u,u,u,u,u,u,u,2,4,8,16,32,64,128,0,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: perlane_shl_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: perlane_shl_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [1,2,4,8,16,32,64,128,u,u,u,u,u,u,u,u,2,4,8,16,32,64,128,0,u,u,u,u,u,u,u,u]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: perlane_shl_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm1 = [1,2,4,8,16,32,64,128,u,u,u,u,u,u,u,u,2,4,8,16,32,64,128,0,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: perlane_shl_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm1 = [1,2,4,8,16,32,64,128,u,u,u,u,u,u,u,u,2,4,8,16,32,64,128,0,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    retq
  %shift = shl <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>, %a
  ret <32 x i8> %shift
}

define <32 x i8> @perlane_lshr_v32i8(<32 x i8> %a) nounwind {
; SSE2-LABEL: perlane_lshr_v32i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    paddb %xmm1, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm1
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pandn %xmm3, %xmm5
; SSE2-NEXT:    psrlw $2, %xmm3
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    por %xmm5, %xmm3
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    pandn %xmm3, %xmm4
; SSE2-NEXT:    psrlw $1, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    psllw $5, %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm3
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm4
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm4
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    pandn %xmm4, %xmm0
; SSE2-NEXT:    psrlw $1, %xmm4
; SSE2-NEXT:    pand %xmm5, %xmm2
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    por %xmm0, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: perlane_lshr_v32i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm2 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm0, %xmm2
; SSE41-NEXT:    movd {{.*#+}} xmm3 = [4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm3, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: perlane_lshr_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovd {{.*#+}} xmm2 = [4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovd {{.*#+}} xmm2 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: perlane_lshr_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxdq {{.*#+}} ymm1 = [259,0,66052,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: perlane_lshr_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm1, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm2, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: perlane_lshr_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmovsxdq {{.*#+}} ymm1 = [259,0,66052,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: perlane_lshr_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovsxdq {{.*#+}} ymm1 = [259,0,66052,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: perlane_lshr_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovsxdq {{.*#+}} ymm1 = [259,0,66052,0]
; AVX512BW-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    retq
  %shift = lshr <32 x i8> <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>, %a
  ret <32 x i8> %shift
}

define <32 x i8> @perlane_ashr_v32i8(<32 x i8> %a) nounwind {
; SSE2-LABEL: perlane_ashr_v32i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $5, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm4
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    paddb %xmm0, %xmm5
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm6
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; SSE2-NEXT:    movdqa %xmm6, %xmm0
; SSE2-NEXT:    pandn %xmm4, %xmm0
; SSE2-NEXT:    psrlw $2, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; SSE2-NEXT:    pand %xmm3, %xmm6
; SSE2-NEXT:    pand %xmm4, %xmm6
; SSE2-NEXT:    por %xmm0, %xmm6
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    pandn %xmm6, %xmm5
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm5
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm6
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm5
; SSE2-NEXT:    movdqa %xmm6, %xmm7
; SSE2-NEXT:    pandn %xmm5, %xmm7
; SSE2-NEXT:    psrlw $2, %xmm5
; SSE2-NEXT:    pand %xmm3, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    por %xmm7, %xmm6
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm6, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: perlane_ashr_v32i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm2 = [5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm0, %xmm2
; SSE41-NEXT:    movd {{.*#+}} xmm3 = [6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm3, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: perlane_ashr_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovd {{.*#+}} xmm2 = [6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovd {{.*#+}} xmm2 = [5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: perlane_ashr_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxdq {{.*#+}} ymm1 = [66053,0,66310,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: perlane_ashr_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm1, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm2, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: perlane_ashr_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmovsxdq {{.*#+}} ymm1 = [66053,0,66310,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: perlane_ashr_v32i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovsxdq {{.*#+}} ymm1 = [66053,0,66310,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: perlane_ashr_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovsxdq {{.*#+}} ymm1 = [66053,0,66310,0]
; AVX512BW-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    retq
  %shift = ashr <32 x i8> <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>, %a
  ret <32 x i8> %shift
}

define <64 x i8> @perlane_shl_v64i8(<64 x i8> %a) nounwind {
; SSE2-LABEL: perlane_shl_v64i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    pandn %xmm4, %xmm7
; SSE2-NEXT:    psllw $2, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    por %xmm7, %xmm0
; SSE2-NEXT:    paddb %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm1
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    psllw $5, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm7
; SSE2-NEXT:    pandn %xmm1, %xmm7
; SSE2-NEXT:    psllw $2, %xmm1
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    por %xmm7, %xmm4
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    pandn %xmm4, %xmm3
; SSE2-NEXT:    paddb %xmm4, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    por %xmm3, %xmm4
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; SSE2-NEXT:    pand %xmm1, %xmm7
; SSE2-NEXT:    paddb %xmm1, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    psubb %xmm1, %xmm7
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pandn %xmm7, %xmm1
; SSE2-NEXT:    psllw $2, %xmm7
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pand %xmm7, %xmm3
; SSE2-NEXT:    por %xmm1, %xmm3
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    pandn %xmm3, %xmm1
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pand %xmm5, %xmm3
; SSE2-NEXT:    por %xmm1, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: perlane_shl_v64i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq {{.*#+}} xmm4 = [7,14,28,56,112,224,192,128,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm0, %xmm4
; SSE41-NEXT:    movq {{.*#+}} xmm5 = [1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm2, %xmm5
; SSE41-NEXT:    movq {{.*#+}} xmm6 = [2,4,8,16,32,64,128,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm3, %xmm6
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    movdqa %xmm5, %xmm2
; SSE41-NEXT:    movdqa %xmm6, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: perlane_shl_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovq {{.*#+}} xmm3 = [2,4,8,16,32,64,128,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vmovq {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vmovq {{.*#+}} xmm2 = [7,14,28,56,112,224,192,128,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: perlane_shl_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [7,14,28,56,112,224,192,128,u,u,u,u,u,u,u,u,0,0,0,0,0,0,0,0,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [1,2,4,8,16,32,64,128,u,u,u,u,u,u,u,u,2,4,8,16,32,64,128,0,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: perlane_shl_v64i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlb %xmm1, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm1, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; XOPAVX1-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: perlane_shl_v64i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [7,14,28,56,112,224,192,128,u,u,u,u,u,u,u,u,0,0,0,0,0,0,0,0,u,u,u,u,u,u,u,u]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [1,2,4,8,16,32,64,128,u,u,u,u,u,u,u,u,2,4,8,16,32,64,128,0,u,u,u,u,u,u,u,u]
; XOPAVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: perlane_shl_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [1,2,4,8,16,32,64,128,u,u,u,u,u,u,u,u,2,4,8,16,32,64,128,0,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [7,14,28,56,112,224,192,128,u,u,u,u,u,u,u,u,0,0,0,0,0,0,0,0,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: perlane_shl_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [7,14,28,56,112,224,192,128,u,u,u,u,u,u,u,u,0,0,0,0,0,0,0,0,u,u,u,u,u,u,u,u,1,2,4,8,16,32,64,128,u,u,u,u,u,u,u,u,2,4,8,16,32,64,128,0,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %shift = shl <64 x i8> <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>, %a
  ret <64 x i8> %shift
}

define <64 x i8> @perlane_lshr_v64i8(<64 x i8> %a) nounwind {
; SSE2-LABEL: perlane_lshr_v64i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    paddb %xmm1, %xmm6
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm6, %xmm8
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; SSE2-NEXT:    movdqa %xmm8, %xmm1
; SSE2-NEXT:    pandn %xmm2, %xmm1
; SSE2-NEXT:    psrlw $2, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm2, %xmm8
; SSE2-NEXT:    por %xmm1, %xmm8
; SSE2-NEXT:    paddb %xmm6, %xmm6
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm6, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pandn %xmm8, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE2-NEXT:    pand %xmm6, %xmm1
; SSE2-NEXT:    pand %xmm8, %xmm1
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    psllw $5, %xmm5
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm2
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm8
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; SSE2-NEXT:    movdqa %xmm8, %xmm9
; SSE2-NEXT:    pandn %xmm2, %xmm9
; SSE2-NEXT:    psrlw $2, %xmm2
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm2, %xmm8
; SSE2-NEXT:    por %xmm9, %xmm8
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    pandn %xmm8, %xmm5
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pand %xmm8, %xmm2
; SSE2-NEXT:    por %xmm5, %xmm2
; SSE2-NEXT:    psllw $5, %xmm3
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm5
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm8
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm5
; SSE2-NEXT:    movdqa %xmm8, %xmm9
; SSE2-NEXT:    pandn %xmm5, %xmm9
; SSE2-NEXT:    psrlw $2, %xmm5
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm5, %xmm8
; SSE2-NEXT:    por %xmm9, %xmm8
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm3
; SSE2-NEXT:    pandn %xmm8, %xmm3
; SSE2-NEXT:    psrlw $1, %xmm8
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pand %xmm8, %xmm5
; SSE2-NEXT:    por %xmm3, %xmm5
; SSE2-NEXT:    psllw $5, %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm3
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm7
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm7
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    pandn %xmm7, %xmm0
; SSE2-NEXT:    psrlw $1, %xmm7
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm7, %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm5, %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: perlane_lshr_v64i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm4 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm0, %xmm4
; SSE41-NEXT:    movd {{.*#+}} xmm5 = [4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm1, %xmm5
; SSE41-NEXT:    movd {{.*#+}} xmm6 = [5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm2, %xmm6
; SSE41-NEXT:    movd {{.*#+}} xmm7 = [6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm3, %xmm7
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    movdqa %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    movdqa %xmm7, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: perlane_lshr_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovd {{.*#+}} xmm3 = [4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vmovd {{.*#+}} xmm3 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovd {{.*#+}} xmm3 = [6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vmovd {{.*#+}} xmm3 = [5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: perlane_lshr_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxdq {{.*#+}} ymm2 = [259,0,66052,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpmovsxdq {{.*#+}} ymm2 = [66053,0,66310,0]
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: perlane_lshr_v64i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm2, %xmm3
; XOPAVX1-NEXT:    vpshlb %xmm3, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm3
; XOPAVX1-NEXT:    vpshlb %xmm3, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm1, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: perlane_lshr_v64i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmovsxdq {{.*#+}} ymm2 = [259,0,66052,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; XOPAVX2-NEXT:    vpmovsxdq {{.*#+}} ymm2 = [66053,0,66310,0]
; XOPAVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: perlane_lshr_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vpmovsxdq {{.*#+}} ymm2 = [66053,0,66310,0]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpmovsxdq {{.*#+}} ymm2 = [259,0,66052,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: perlane_lshr_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovsxdq {{.*#+}} zmm1 = [259,0,66052,0,66053,0,66310,0]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %shift = lshr <64 x i8> <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>, %a
  ret <64 x i8> %shift
}

define <64 x i8> @perlane_ashr_v64i8(<64 x i8> %a) nounwind {
; SSE2-LABEL: perlane_ashr_v64i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $5, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    paddb %xmm1, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm6
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    pandn %xmm0, %xmm6
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pandn %xmm6, %xmm5
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pand %xmm6, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    psllw $5, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm6
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm5
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    paddb %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtb %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    pandn %xmm6, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    pand %xmm0, %xmm5
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    por %xmm2, %xmm5
; SSE2-NEXT:    psllw $5, %xmm3
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm2
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm6
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; SSE2-NEXT:    pandn %xmm2, %xmm6
; SSE2-NEXT:    paddb %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm2
; SSE2-NEXT:    pandn %xmm6, %xmm2
; SSE2-NEXT:    psrlw $1, %xmm6
; SSE2-NEXT:    pand %xmm0, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: perlane_ashr_v64i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbq {{.*#+}} xmm4 = [1,0]
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    movd {{.*#+}} xmm5 = [2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm2, %xmm5
; SSE41-NEXT:    movd {{.*#+}} xmm6 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    pshufb %xmm3, %xmm6
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    movdqa %xmm4, %xmm1
; SSE41-NEXT:    movdqa %xmm5, %xmm2
; SSE41-NEXT:    movdqa %xmm6, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: perlane_ashr_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovd {{.*#+}} xmm3 = [3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vmovd {{.*#+}} xmm3 = [2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm2 = [1,0]
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: perlane_ashr_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,0,1,0]
; AVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpmovsxwq {{.*#+}} ymm2 = [258,0,259,0]
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; XOPAVX1-LABEL: perlane_ashr_v64i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm3
; XOPAVX1-NEXT:    vpshlb %xmm3, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm1, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsubb %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; XOPAVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: perlane_ashr_v64i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,0,1,0]
; XOPAVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; XOPAVX2-NEXT:    vpmovsxwq {{.*#+}} ymm2 = [258,0,259,0]
; XOPAVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; XOPAVX2-NEXT:    retq
;
; AVX512DQ-LABEL: perlane_ashr_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512DQ-NEXT:    vpmovsxwq {{.*#+}} ymm2 = [258,0,259,0]
; AVX512DQ-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,0,1,0]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: perlane_ashr_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovsxwq {{.*#+}} zmm1 = [0,0,1,0,258,0,259,0]
; AVX512BW-NEXT:    vpshufb %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <64 x i8> <i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>, %a
  ret <64 x i8> %shift
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; SSE: {{.*}}
