; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d < %s | FileCheck %s --check-prefix=LA32R
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d < %s | FileCheck %s --check-prefix=LA32S
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64

declare void @bar()

define void @bnez_i32(i32 signext %0) nounwind {
; LA32R-LABEL: bnez_i32:
; LA32R:       # %bb.0: # %start
; LA32R-NEXT:    beq $a0, $zero, .LBB0_2
; LA32R-NEXT:  # %bb.1: # %f
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB0_2: # %t
; LA32R-NEXT:    b bar
;
; LA32S-LABEL: bnez_i32:
; LA32S:       # %bb.0: # %start
; LA32S-NEXT:    beqz $a0, .LBB0_2
; LA32S-NEXT:  # %bb.1: # %f
; LA32S-NEXT:    ret
; LA32S-NEXT:  .LBB0_2: # %t
; LA32S-NEXT:    b bar
;
; LA64-LABEL: bnez_i32:
; LA64:       # %bb.0: # %start
; LA64-NEXT:    beqz $a0, .LBB0_2
; LA64-NEXT:  # %bb.1: # %f
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB0_2: # %t
; LA64-NEXT:    pcaddu18i $t8, %call36(bar)
; LA64-NEXT:    jr $t8
start:
  %1 = icmp eq i32 %0, 0
  br i1 %1, label %t, label %f

t:
  tail call void @bar()
  br label %f

f:
  ret void
}

define void @beqz_i32(i32 signext %0) nounwind {
; LA32R-LABEL: beqz_i32:
; LA32R:       # %bb.0: # %start
; LA32R-NEXT:    beq $a0, $zero, .LBB1_2
; LA32R-NEXT:  # %bb.1: # %t
; LA32R-NEXT:    b bar
; LA32R-NEXT:  .LBB1_2: # %f
; LA32R-NEXT:    ret
;
; LA32S-LABEL: beqz_i32:
; LA32S:       # %bb.0: # %start
; LA32S-NEXT:    beqz $a0, .LBB1_2
; LA32S-NEXT:  # %bb.1: # %t
; LA32S-NEXT:    b bar
; LA32S-NEXT:  .LBB1_2: # %f
; LA32S-NEXT:    ret
;
; LA64-LABEL: beqz_i32:
; LA64:       # %bb.0: # %start
; LA64-NEXT:    beqz $a0, .LBB1_2
; LA64-NEXT:  # %bb.1: # %t
; LA64-NEXT:    pcaddu18i $t8, %call36(bar)
; LA64-NEXT:    jr $t8
; LA64-NEXT:  .LBB1_2: # %f
; LA64-NEXT:    ret
start:
  %1 = icmp ne i32 %0, 0
  br i1 %1, label %t, label %f

t:
  tail call void @bar()
  br label %f

f:
  ret void
}

define void @bnez_i64(i64 %0) nounwind {
; LA32R-LABEL: bnez_i64:
; LA32R:       # %bb.0: # %start
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    beq $a0, $zero, .LBB2_2
; LA32R-NEXT:  # %bb.1: # %f
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB2_2: # %t
; LA32R-NEXT:    b bar
;
; LA32S-LABEL: bnez_i64:
; LA32S:       # %bb.0: # %start
; LA32S-NEXT:    or $a0, $a0, $a1
; LA32S-NEXT:    beqz $a0, .LBB2_2
; LA32S-NEXT:  # %bb.1: # %f
; LA32S-NEXT:    ret
; LA32S-NEXT:  .LBB2_2: # %t
; LA32S-NEXT:    b bar
;
; LA64-LABEL: bnez_i64:
; LA64:       # %bb.0: # %start
; LA64-NEXT:    beqz $a0, .LBB2_2
; LA64-NEXT:  # %bb.1: # %f
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB2_2: # %t
; LA64-NEXT:    pcaddu18i $t8, %call36(bar)
; LA64-NEXT:    jr $t8
start:
  %1 = icmp eq i64 %0, 0
  br i1 %1, label %t, label %f

t:
  tail call void @bar()
  br label %f

f:
  ret void
}

define void @beqz_i64(i64 %0) nounwind {
; LA32R-LABEL: beqz_i64:
; LA32R:       # %bb.0: # %start
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    beq $a0, $zero, .LBB3_2
; LA32R-NEXT:  # %bb.1: # %t
; LA32R-NEXT:    b bar
; LA32R-NEXT:  .LBB3_2: # %f
; LA32R-NEXT:    ret
;
; LA32S-LABEL: beqz_i64:
; LA32S:       # %bb.0: # %start
; LA32S-NEXT:    or $a0, $a0, $a1
; LA32S-NEXT:    beqz $a0, .LBB3_2
; LA32S-NEXT:  # %bb.1: # %t
; LA32S-NEXT:    b bar
; LA32S-NEXT:  .LBB3_2: # %f
; LA32S-NEXT:    ret
;
; LA64-LABEL: beqz_i64:
; LA64:       # %bb.0: # %start
; LA64-NEXT:    beqz $a0, .LBB3_2
; LA64-NEXT:  # %bb.1: # %t
; LA64-NEXT:    pcaddu18i $t8, %call36(bar)
; LA64-NEXT:    jr $t8
; LA64-NEXT:  .LBB3_2: # %f
; LA64-NEXT:    ret
start:
  %1 = icmp ne i64 %0, 0
  br i1 %1, label %t, label %f

t:
  tail call void @bar()
  br label %f

f:
  ret void
}
