; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=+d < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64

define i1 @andn_icmp_eq_i8(i8 signext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmpeq = icmp eq i8 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_icmp_eq_i16(i16 signext %a, i16 signext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i16 %a, %b
  %cmpeq = icmp eq i16 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_icmp_eq_i32(i32 signext %a, i32 signext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i32 %a, %b
  %cmpeq = icmp eq i32 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_icmp_eq_i64(i64 %a, i64 %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a1, $a3, $a1
; LA32-NEXT:    andn $a0, $a2, $a0
; LA32-NEXT:    or $a0, $a0, $a1
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i64 %a, %b
  %cmpeq = icmp eq i64 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_icmp_ne_i8(i8 signext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ne_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltu $a0, $zero, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ne_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltu $a0, $zero, $a0
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmpne = icmp ne i8 %and, %b
  ret i1 %cmpne
}

define i1 @andn_icmp_ne_i16(i16 signext %a, i16 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ne_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltu $a0, $zero, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ne_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltu $a0, $zero, $a0
; LA64-NEXT:    ret
  %and = and i16 %a, %b
  %cmpne = icmp ne i16 %and, %b
  ret i1 %cmpne
}

define i1 @andn_icmp_ne_i32(i32 signext %a, i32 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ne_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltu $a0, $zero, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ne_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltu $a0, $zero, $a0
; LA64-NEXT:    ret
  %and = and i32 %a, %b
  %cmpne = icmp ne i32 %and, %b
  ret i1 %cmpne
}

define i1 @andn_icmp_ne_i64(i64 %a, i64 %b) nounwind {
; LA32-LABEL: andn_icmp_ne_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a1, $a3, $a1
; LA32-NEXT:    andn $a0, $a2, $a0
; LA32-NEXT:    or $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $zero, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ne_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltu $a0, $zero, $a0
; LA64-NEXT:    ret
  %and = and i64 %a, %b
  %cmpne = icmp ne i64 %and, %b
  ret i1 %cmpne
}

define i1 @andn_icmp_ult_i8(i8 signext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i16(i16 signext %a, i16 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i16 %a, %b
  %cmp = icmp ult i16 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_uge_i8(i8 signext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_uge_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    xori $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_uge_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    xori $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp uge i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_uge_i16(i16 signext %a, i16 signext %b) nounwind {
; LA32-LABEL: andn_icmp_uge_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    xori $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_uge_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    xori $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i16 %a, %b
  %cmp = icmp uge i16 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ugt_i8(i8 signext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ugt_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a1, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ugt_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a1, $a0
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ugt i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ugt_i16(i16 signext %a, i16 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ugt_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a1, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ugt_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a1, $a0
; LA64-NEXT:    ret
  %and = and i16 %a, %b
  %cmp = icmp ugt i16 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ule_i8(i8 signext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ule_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a1, $a0
; LA32-NEXT:    xori $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ule_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a1, $a0
; LA64-NEXT:    xori $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ule i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ule_i16(i16 signext %a, i16 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ule_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a1, $a0
; LA32-NEXT:    xori $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ule_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a1, $a0
; LA64-NEXT:    xori $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i16 %a, %b
  %cmp = icmp ule i16 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_sz(i8 signext %a, i8 zeroext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_sz:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_sz:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp eq i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_zs(i8 zeroext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_zs:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    andi $a0, $a0, 255
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_zs:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp eq i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_zz(i8 zeroext %a, i8 zeroext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_zz:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_zz:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp eq i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_sn(i8 signext %a, i8 %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_sn:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    andi $a0, $a0, 255
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_sn:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp eq i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_zn(i8 zeroext %a, i8 %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_zn:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    andi $a0, $a0, 255
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_zn:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp eq i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_ns(i8 %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_ns:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    andi $a0, $a0, 255
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_ns:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp eq i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_nz(i8 %a, i8 zeroext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_nz:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_nz:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp eq i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_nn(i8 %a, i8 %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_nn:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    andi $a0, $a0, 255
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_nn:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp eq i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i8_sz(i8 signext %a, i8 zeroext %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8_sz:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8_sz:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i8_zs(i8 zeroext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8_zs:
; LA32:       # %bb.0:
; LA32-NEXT:    andi $a1, $a1, 255
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8_zs:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i8_zz(i8 zeroext %a, i8 zeroext %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8_zz:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8_zz:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i8_sn(i8 signext %a, i8 %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8_sn:
; LA32:       # %bb.0:
; LA32-NEXT:    andi $a1, $a1, 255
; LA32-NEXT:    and $a0, $a1, $a0
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8_sn:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    and $a0, $a1, $a0
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i8_zn(i8 zeroext %a, i8 %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8_zn:
; LA32:       # %bb.0:
; LA32-NEXT:    andi $a1, $a1, 255
; LA32-NEXT:    and $a0, $a1, $a0
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8_zn:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    and $a0, $a1, $a0
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i8_ns(i8 %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8_ns:
; LA32:       # %bb.0:
; LA32-NEXT:    andi $a1, $a1, 255
; LA32-NEXT:    and $a0, $a1, $a0
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8_ns:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    and $a0, $a1, $a0
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i8_nz(i8 %a, i8 zeroext %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8_nz:
; LA32:       # %bb.0:
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8_nz:
; LA64:       # %bb.0:
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_ult_i8_nn(i8 %a, i8 %b) nounwind {
; LA32-LABEL: andn_icmp_ult_i8_nn:
; LA32:       # %bb.0:
; LA32-NEXT:    andi $a1, $a1, 255
; LA32-NEXT:    and $a0, $a1, $a0
; LA32-NEXT:    sltu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_ult_i8_nn:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    and $a0, $a1, $a0
; LA64-NEXT:    sltu $a0, $a0, $a1
; LA64-NEXT:    ret
  %and = and i8 %a, %b
  %cmp = icmp ult i8 %and, %b
  ret i1 %cmp
}

define i1 @andn_icmp_eq_i8_i32(i8 signext %a, i8 signext %b) nounwind {
; LA32-LABEL: andn_icmp_eq_i8_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    sltui $a0, $a0, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: andn_icmp_eq_i8_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
  %x = zext i8 %a to i32
  %y = zext i8 %b to i32
  %not = xor i32 %x, -1
  %and = and i32 %not, %y
  %cmp = icmp eq i32 %and, 0
  ret i1 %cmp
}
