---
layout: default
title: Contacts and Mailing Lists
nav_order: 150
---

<!--
© 2025 and later: Unicode, Inc. and others.
License & terms of use: http://www.unicode.org/copyright.html
-->

# Contacts and Mailing Lists

ICU uses several mailing lists for discussions, announcements and notifications. The mailing list server provides web-based subscription with several options, list archives, digest mode, etc. Please follow the links to the mailing lists you are interested in.

*Note:* In order to post to the support or design lists you *must subscribe first* — posts by non-members are rejected. You can browse the list archives without subscribing by following the links below, or search the archives.

As a general rule of etiquette, please do not include confidential information or mark your emails as urgent. These are public mailing lists used by many volunteers. The volunteers will try to answer your question as soon as possible.

## Mailing lists

**[icu-support@unicode.org](https://groups.google.com/a/unicode.org/g/icu-support)**

ICU C/C++/Java usage discussions, support and platform specific issues (e.g. downloading, compiling, linking, packaging, debugging, ICU API usage, ICU data, etc.)

You can also subscribe by sending an email to icu-support+subscribe@unicode.org

**[icu-announce@unicode.org](https://groups.google.com/a/unicode.org/g/icu-announce)**

Contains important announcements about the ICU project, such as new releases. **Read-only.**

You can also subscribe by sending an email to icu-announce+subscribe@unicode.org

**[icu-design@unicode.org](https://groups.google.com/a/unicode.org/g/icu-design)**

This list is for API proposals and their discussion. *(If you have a problem building ICU, or a question about using ICU, do not use this list — use icu-support instead.)*

You can also subscribe by sending an email to icu-design+subscribe@unicode.org

## Bugs & feature requests

You can **report a bug or request a new feature** with the [bug tracking system](https://icu.unicode.org/bugs). (This is not a mailing list, but a web-based bug tracking system). If you have an ICU4C or ICU4J build problem, you will get a faster response from the icu-support mailing list. Please do not use the icu-design mailing list for build issues.

## Obsolete mailing lists

The following mailing lists preserve archived discussions. They are closed for new discussion.

https://groups.google.com/a/unicode.org/g/icu-charsets

An archived list about ICU conversion data and API. (inactive list; active 2001-2003)

https://groups.google.com/a/unicode.org/g/icu-issues

An archived list of pre-issue-tracker ICU issues (inactive list; active 2001-2004)