
dnl RFM_ENABLE_PLUGIN(varname, optionname, option string, option string 2, [default])
dnl
dnl This macro automatically adds a commandline switch based on the "optionname"
dnl parameter (--enable-optionname/--disable-optionname), which allows the
dnl user to explicitly control whether this option should be
dnl enabled or not. The "option string" parameter gives a brief description
dnl about this switch.
dnl
dnl If the user chose to enable this option defines a WITH_"varname" for
dnl use in Makefile.am
dnl
AC_DEFUN([RFM_ENABLE_PLUGIN],
[

  AC_ARG_ENABLE([$2],[AC_HELP_STRING([--enable-$2], [Create "$3" $4 [[default=$5]]])],,enable_$2=$5) 
  AM_CONDITIONAL([WANT_$1_P], [test x$enable_$2 = xyes])
  AC_SUBST(WITH_$1) 
  if test x$enable_$2 = xyes; then
	WITH_$1=yes
  else
	WITH_$1=no
  fi
])

AC_DEFUN([RFM_CHECK_DISTRO],
[
AC_MSG_CHECKING(distro);
result=`ls -l /sbin/yast 2>/dev/null | grep yast2`
    if test x"${result}" = x; then
	AC_MSG_RESULT([ not Suse.])
	AC_SUBST(LIBRSVG_NAME) LIBRSVG_NAME=librsvg2
	AC_SUBST(DISTRO_X) DISTRO_X=libSM-devel
	AC_SUBST(DISTRO_X_VERSION) DISTRO_X_VERSION=1.2

    else 
	AC_MSG_RESULT([ Suse.])
	AC_SUBST(LIBRSVG_NAME) LIBRSVG_NAME=librsvg
	AC_SUBST(DISTRO_X) DISTRO_X=xorg-x11-devel
	AC_SUBST(DISTRO_X_VERSION) DISTRO_X_VERSION=7.6
    fi

AC_MSG_CHECKING(for gentoo emerge)
AC_CHECK_PROG(cv_emerge, emerge, yes, no)
AM_CONDITIONAL(WANT_GENTOO, [test "$cv_emerge" != no])

AC_MSG_CHECKING(for debian dpkg)
AC_CHECK_PROG(cv_dpkg, dpkg, yes, no)
AM_CONDITIONAL(WANT_DEBIAN, [test "$cv_dpkg" != no])

])

AC_DEFUN([RFM_CORE],
[
AC_ARG_WITH([core],[AC_HELP_STRING([--with-core], [Enable core dumps])]) 
if test "$with_core" = "yes"
then
	AC_SUBST(WITH_CORE) WITH_CORE=yes
	AC_SUBST(CORE)
	AC_DEFINE_UNQUOTED([CORE],[$with_core],[enable CORE])
	AC_MSG_NOTICE([You enabled core dumps. Good for you.])
elif test "$with_core" != ""
then
	AC_SUBST(WITH_CORE) WITH_CORE=yes
	AC_MSG_NOTICE([Your specific kind of core dumps is $with_core])
	AC_SUBST(CORE)
	AC_DEFINE_UNQUOTED([CORE],[$with_core],[enable CORE])

else
	AC_SUBST(WITH_CORE) WITH_CORE=no
	AC_MSG_NOTICE([No core dumps for you.])
fi
])


AC_DEFUN([RFM_DEBUG],
[
AC_ARG_WITH([debug], [AC_HELP_STRING([--with-debug], [Enable debug])])
if test "$with_debug" = "yes"
then
	AC_SUBST(WITH_CORE) WITH_CORE=yes
	AC_SUBST(CORE)
	AC_DEFINE_UNQUOTED([CORE],[$with_core],[enable CORE])
	AC_SUBST(WITH_DEBUG) WITH_DEBUG=yes
	AC_SUBST(DEBUG)
	AC_DEFINE_UNQUOTED([DEBUG],[$with_debug],[enable DEBUG])
	AC_MSG_NOTICE([You enabled debug. Good for you.])
	DB=--with-debug
	CFLAGS="-O0 -ggdb"
elif test "$with_debug" != ""
then
	AC_SUBST(WITH_CORE) WITH_CORE=yes
	AC_SUBST(CORE)
	AC_DEFINE_UNQUOTED([CORE],[$with_core],[enable CORE])
	AC_SUBST(WITH_DEBUG) WITH_DEBUG=yes
	AC_MSG_NOTICE([Your specific kind of debug is $with_debug])
	AC_SUBST(DEBUG)
	AC_DEFINE_UNQUOTED([DEBUG],[$with_debug],[enable DEBUG])
	CFLAGS="-O0 -ggdb"

else
	AC_SUBST(WITH_DEBUG) WITH_DEBUG=no
	AC_MSG_NOTICE([No debug for you.])
	CFLAGS="-O2"
fi
])

AC_DEFUN([RFM_TRACE],
[
AC_ARG_WITH([trace], [AC_HELP_STRING([--with-trace],[Enable trace])])
if test "$with_trace" = "yes"
then
	AC_SUBST(WITH_CORE) WITH_CORE=yes
	AC_SUBST(CORE)
	AC_DEFINE_UNQUOTED([CORE],[$with_core],[enable CORE])
	AC_MSG_NOTICE([You enabled trace. Good for you.])
	AC_SUBST(WITH_TRACE) WITH_TRACE=yes
	DEBUG_TRACE=yes
	AC_SUBST(DEBUG_TRACE)
	AC_DEFINE_UNQUOTED([DEBUG_TRACE],[$with_trace],[enable DEBUG_TRACE])
	TR=--with-trace
elif test "$with_trace" != ""
then
	AC_SUBST(WITH_CORE) WITH_CORE=yes
	AC_SUBST(CORE)
	AC_DEFINE_UNQUOTED([CORE],[$with_core],[enable CORE])
	AC_SUBST(WITH_TRACE) WITH_TRACE=yes
	DEBUG_TRACE=yes
	AC_SUBST(DEBUG_TRACE)
	AC_DEFINE_UNQUOTED([DEBUG_TRACE],[$with_trace],[enable DEBUG_TRACE])
	AC_MSG_NOTICE([Your specific kind of trace is $with_trace])
else
	AC_SUBST(WITH_TRACE) WITH_TRACE=no
	AC_SUBST(DEBUG_TRACE)
	AC_MSG_NOTICE([No trace for you.])
fi
])

AC_DEFUN([RFM_GNU_GREP],[
AC_MSG_CHECKING([for GNU grep])
GAWK_VERSION=`grep --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`

if test $INDEX -gt  0 ; then
    AC_MSG_RESULT([GNU grep found])
    GNU_GREP=1
    AC_SUBST(WITH_GNU_GREP) WITH_GNU_GREP=yes
    AC_SUBST(GNU_GREP)
    AC_DEFINE_UNQUOTED([GNU_GREP],[$GNU_GREP],[enable GNU grep])
else
    AC_SUBST(WITH_GNU_GREP) WITH_GNU_GREP=no
    AC_MSG_RESULT([grep is not GNU. Some features will be define by BSD!])
fi

])

AC_DEFUN([RFM_GNU_LS],
[
AC_MSG_CHECKING([for GNU ls])
GAWK_VERSION=`ls --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`

if test $INDEX -gt  0 ; then
    AC_MSG_RESULT([GNU ls found])
    GNU_LS=1
    AC_SUBST(WITH_GNU_LS) WITH_GNU_LS=yes
    AC_SUBST(GNU_LS)
    AC_DEFINE_UNQUOTED([GNU_LS],[$GNU_LS],[enable GNU ls])
else
    AC_SUBST(WITH_GNU_LS) WITH_GNU_LS=no
    AC_MSG_RESULT([ls is not GNU. Some features will be define by BSD!])
fi
])

AC_DEFUN([RFM_GNU_CP],
[
AC_MSG_CHECKING([for GNU cp])
GAWK_VERSION=`cp --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`

if test $INDEX -gt  0 ; then
    AC_MSG_RESULT([GNU cp found])
    GNU_CP=1
    AC_SUBST(WITH_GNU_CP) WITH_GNU_CP=yes
    AC_SUBST(GNU_CP)
    AC_DEFINE_UNQUOTED([GNU_CP],[$GNU_CP],[enable GNU cp])
else
    AC_SUBST(WITH_GNU_CP) WITH_GNU_CP=no
    AC_MSG_RESULT([cp is not GNU. Some features will be define by BSD!])
fi
])

AC_DEFUN([RFM_GNU_MV],
[
AC_MSG_CHECKING([for GNU mv])
GAWK_VERSION=`mv --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`

if test $INDEX -gt  0 ; then
    AC_MSG_RESULT([GNU mv found])
    GNU_MV=1
    AC_SUBST(WITH_GNU_MV) WITH_GNU_MV=yes
    AC_SUBST(GNU_MV)
    AC_DEFINE_UNQUOTED([GNU_MV],[$GNU_MV],[enable GNU mv])
else
    AC_SUBST(WITH_GNU_MV) WITH_GNU_MV=no
    AC_MSG_RESULT([mv is not GNU. Some features will be define by BSD!])
fi
])

AC_DEFUN([RFM_GNU_LN],
[
AC_MSG_CHECKING([for GNU ln])
GAWK_VERSION=`ln --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`

if test $INDEX -gt  0 ; then
    AC_MSG_RESULT([GNU ln found])
    GNU_LN=1
    AC_SUBST(WITH_GNU_LN) WITH_GNU_LN=yes
    AC_SUBST(GNU_LN)
    AC_DEFINE_UNQUOTED([GNU_LN],[$GNU_LN],[enable GNU ln])
else
    AC_SUBST(WITH_GNU_LN) WITH_GNU_LN=no
    AC_MSG_RESULT([ln is not GNU. Some features will not be enabled!])
fi
])

AC_DEFUN([RFM_GNU_RM],
[
AC_MSG_CHECKING([for GNU rm])
GAWK_VERSION=`rm --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`
#echo "INDEX=$INDEX"

if test $INDEX -gt 0 ; then
    AC_MSG_RESULT([GNU rm found])
    GNU_RM=1
    AC_SUBST(WITH_GNU_RM) WITH_GNU_RM=yes
    AC_SUBST(GNU_RM)
    AC_DEFINE_UNQUOTED([GNU_RM],[$GNU_RM],[enable GNU rm])
else
    AC_SUBST(WITH_GNU_RM) WITH_GNU_RM=no
    AC_MSG_RESULT([rm is not GNU. Some features will not be enabled!])
fi
])

AC_DEFUN([RFM_GNU_SHRED],
[
AC_MSG_CHECKING([for GNU shred])
GAWK_VERSION=`shred --version`
INDEX=`expr "$GAWK_VERSION" : "[.*GNU]"`
#echo "INDEX=$INDEX"

if test $INDEX -gt 0 ; then
    AC_MSG_RESULT([GNU shred found])
    GNU_SHRED=1
    AC_SUBST(WITH_GNU_SHRED) WITH_GNU_SHRED=yes
    AC_SUBST(GNU_SHRED)
    AC_DEFINE_UNQUOTED([GNU_SHRED],[$GNU_SHRED],[enable GNU shred])
else
    AC_SUBST(WITH_GNU_SHRED) WITH_GNU_SHRED=no
    AC_MSG_RESULT([shred is not GNU. Some features will not be enabled!])
fi
])

AC_DEFUN([RFM_GNU_GHOSTSCRIPT],
[
AC_MSG_CHECKING([for GNU Ghostscript])
GS_VERSION=`gs --version`
if test x"$GS_VERSION" = x; then
    AC_SUBST(WITH_GNU_GS) WITH_GNU_GS=no
    AC_MSG_RESULT([GNU Ghostscript not found])
else
    AC_SUBST(WITH_GNU_GS) WITH_GNU_GS=yes
    AC_MSG_RESULT([Ghostscript found])
fi
])


AC_DEFUN([RFM_LINUX_OR_BSD],
[
AC_MSG_CHECKING(for Linux or FreeBSD/OpenBSD)
ac_uname_s=`uname -s`
#echo "system: $ac_uname_s"
AM_CONDITIONAL(WANT_FREEBSD, [test "$ac_uname_s" = "FreeBSD" || test "$ac_uname_s" = "OpenBSD"])

if test "$ac_uname_s" = "FreeBSD" || test "$ac_uname_s" = "OpenBSD"; then
	AC_MSG_RESULT([System is FreeBSD or OpenBSD.])
	AC_MSG_CHECKING(for gmake);
	result_gmake=`gmake --version`
	if test x"${result_gmake}" = x; then
	    AC_MSG_ERROR([GNU make (gmake) not found! Please install and then rerun configure.])
	else 
	    echo "$result_gmake"
	fi
	AC_DEFINE_UNQUOTED([THIS_IS_BSD], [1], [Define if system is BSD (Free or Open)])

else 
   if test "$ac_uname_s" = "Linux" ; then
	AC_DEFINE_UNQUOTED([THIS_IS_LINUX], [1], [Define if system is Linux kernel and posix shared memory is at /dev/shm])
	AC_MSG_RESULT([System is Linux.])
   else
        AC_MSG_RESULT([Unknown system... mingw-w64?])
   fi
fi
AC_SUBST(UNAME_S) UNAME_S=$ac_uname_s

])

AC_DEFUN([RFM_GNU_AWK],
[
AC_MSG_CHECKING([for GNU Awk])
GAWK_VERSION=`gawk --version`
INDEX=`expr "$GAWK_VERSION" : "[GNU Awk]"`
#echo "INDEX=$INDEX"
if test $INDEX -gt 0 ; then
    AC_MSG_RESULT([GNU gawk found])
else
    AC_MSG_ERROR([GNU gawk not found! Please install and then rerun configure.])
fi
])

AC_DEFUN([RFM_MAX_PREVIEW_THREADS],
[
AC_ARG_WITH([mpt], [AC_HELP_STRING([--with-mpt],[max preview threads (default=4)])])
if test "$with_mpt" != ""
then
	AC_SUBST(WITH_MPT) WITH_MPT=$with_mpt
	AC_DEFINE_UNQUOTED([MAX_PREVIEW_THREADS],[$with_mpt],[maximum preview threads])
	AC_MSG_NOTICE([Maximum preview threads set to $with_mpt])
else
	AC_SUBST(WITH_MPT) WITH_MPT=4
	AC_DEFINE_UNQUOTED([MAX_PREVIEW_THREADS],[4],[maximum preview threads])
	AC_MSG_NOTICE([Maximum preview threads set to 4])
fi
])

